/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.sharding;

import com.dangdang.ddframe.job.lite.api.strategy.JobInstance;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategy;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategyFactory;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.election.LeaderService;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceService;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.sharding.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingNode;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.lite.internal.storage.TransactionExecutionCallback;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.util.concurrent.BlockUtils;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingService {
    private static final Logger log = LoggerFactory.getLogger(ShardingService.class);
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final LeaderService leaderService;
    private final ConfigurationService configService;
    private final InstanceService instanceService;
    private final ServerService serverService;
    private final ExecutionService executionService;
    private final JobNodePath jobNodePath;

    public ShardingService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.jobNodePath = new JobNodePath(jobName);
    }

    public void setReshardingFlag() {
        this.jobNodeStorage.createJobNodeIfNeeded("leader/sharding/necessary");
    }

    public boolean isNeedSharding() {
        return this.jobNodeStorage.isJobNodeExisted("leader/sharding/necessary");
    }

    public void shardingIfNecessary() {
        List<JobInstance> availableJobInstances = this.instanceService.getAvailableJobInstances();
        if (!this.isNeedSharding() || availableJobInstances.isEmpty()) {
            return;
        }
        if (!this.leaderService.isLeaderUntilBlock()) {
            this.blockUntilShardingCompleted();
            return;
        }
        this.waitingOtherJobCompleted();
        LiteJobConfiguration liteJobConfig = this.configService.load(false);
        int shardingTotalCount = liteJobConfig.getTypeConfig().getCoreConfig().getShardingTotalCount();
        log.debug("Job '{}' sharding begin.", (Object)this.jobName);
        this.jobNodeStorage.fillEphemeralJobNode("leader/sharding/processing", "");
        this.resetShardingInfo(shardingTotalCount);
        JobShardingStrategy jobShardingStrategy = JobShardingStrategyFactory.getStrategy(liteJobConfig.getJobShardingStrategyClass());
        this.jobNodeStorage.executeInTransaction(new PersistShardingInfoTransactionExecutionCallback(jobShardingStrategy.sharding(availableJobInstances, this.jobName, shardingTotalCount)));
        log.debug("Job '{}' sharding complete.", (Object)this.jobName);
    }

    private void blockUntilShardingCompleted() {
        while (!this.leaderService.isLeaderUntilBlock() && (this.jobNodeStorage.isJobNodeExisted("leader/sharding/necessary") || this.jobNodeStorage.isJobNodeExisted("leader/sharding/processing"))) {
            log.debug("Job '{}' sleep short time until sharding completed.", (Object)this.jobName);
            BlockUtils.waitingShortTime();
        }
    }

    private void waitingOtherJobCompleted() {
        while (this.executionService.hasRunningItems()) {
            log.debug("Job '{}' sleep short time until other job completed.", (Object)this.jobName);
            BlockUtils.waitingShortTime();
        }
    }

    private void resetShardingInfo(int shardingTotalCount) {
        for (int i = 0; i < shardingTotalCount; ++i) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getInstanceNode(i));
            this.jobNodeStorage.createJobNodeIfNeeded("sharding/" + i);
        }
        int actualShardingTotalCount = this.jobNodeStorage.getJobNodeChildrenKeys("sharding").size();
        if (actualShardingTotalCount > shardingTotalCount) {
            for (int i = shardingTotalCount; i < actualShardingTotalCount; ++i) {
                this.jobNodeStorage.removeJobNodeIfExisted("sharding/" + i);
            }
        }
    }

    public List<Integer> getShardingItems(String jobInstanceId) {
        JobInstance jobInstance = new JobInstance(jobInstanceId);
        if (!this.serverService.isAvailableServer(jobInstance.getIp())) {
            return Collections.emptyList();
        }
        LinkedList<Integer> result = new LinkedList<Integer>();
        int shardingTotalCount = this.configService.load(true).getTypeConfig().getCoreConfig().getShardingTotalCount();
        for (int i = 0; i < shardingTotalCount; ++i) {
            if (!jobInstance.getJobInstanceId().equals(this.jobNodeStorage.getJobNodeData(ShardingNode.getInstanceNode(i)))) continue;
            result.add(i);
        }
        return result;
    }

    public List<Integer> getLocalShardingItems() {
        if (JobRegistry.getInstance().isShutdown(this.jobName) || !this.serverService.isAvailableServer(JobRegistry.getInstance().getJobInstance(this.jobName).getIp())) {
            return Collections.emptyList();
        }
        return this.getShardingItems(JobRegistry.getInstance().getJobInstance(this.jobName).getJobInstanceId());
    }

    public boolean hasShardingInfoInOfflineServers() {
        List<String> onlineInstances = this.jobNodeStorage.getJobNodeChildrenKeys("instances");
        int shardingTotalCount = this.configService.load(true).getTypeConfig().getCoreConfig().getShardingTotalCount();
        for (int i = 0; i < shardingTotalCount; ++i) {
            if (onlineInstances.contains(this.jobNodeStorage.getJobNodeData(ShardingNode.getInstanceNode(i)))) continue;
            return true;
        }
        return false;
    }

    class PersistShardingInfoTransactionExecutionCallback
    implements TransactionExecutionCallback {
        private final Map<JobInstance, List<Integer>> shardingResults;

        @Override
        public void execute(CuratorTransactionFinal curatorTransactionFinal) throws Exception {
            for (Map.Entry<JobInstance, List<Integer>> entry : this.shardingResults.entrySet()) {
                for (int shardingItem : entry.getValue()) {
                    ((CuratorTransactionBridge)curatorTransactionFinal.create().forPath(ShardingService.this.jobNodePath.getFullPath(ShardingNode.getInstanceNode(shardingItem)), entry.getKey().getJobInstanceId().getBytes())).and();
                }
            }
            ((CuratorTransactionBridge)curatorTransactionFinal.delete().forPath(ShardingService.this.jobNodePath.getFullPath("leader/sharding/necessary"))).and();
            ((CuratorTransactionBridge)curatorTransactionFinal.delete().forPath(ShardingService.this.jobNodePath.getFullPath("leader/sharding/processing"))).and();
        }

        @ConstructorProperties(value={"shardingResults"})
        public PersistShardingInfoTransactionExecutionCallback(Map<JobInstance, List<Integer>> shardingResults) {
            this.shardingResults = shardingResults;
        }
    }
}

