/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SensitiveInfoUtils {
    private static final String FAKE_IP_SAMPLE = "ip";

    public static List<String> filterSensitiveIps(List<String> target) {
        final HashMap fakeIpMap = new HashMap();
        final AtomicInteger step = new AtomicInteger();
        return Lists.transform(target, (Function)new Function<String, String>(){

            public String apply(String input) {
                Matcher matcher = Pattern.compile("((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})").matcher(input);
                String result = input;
                while (matcher.find()) {
                    String fakeIp;
                    String realIp = matcher.group();
                    if (fakeIpMap.containsKey(realIp)) {
                        fakeIp = (String)fakeIpMap.get(realIp);
                    } else {
                        fakeIp = Joiner.on((String)"").join((Object)SensitiveInfoUtils.FAKE_IP_SAMPLE, (Object)step.incrementAndGet(), new Object[0]);
                        fakeIpMap.put(realIp, fakeIp);
                    }
                    result = result.replace(realIp, fakeIp);
                }
                return result;
            }
        });
    }

    private SensitiveInfoUtils() {
    }
}

