/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.spring.job.util;

import com.dangdang.ddframe.job.exception.JobSystemException;
import java.lang.reflect.Field;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;

public final class AopTargetUtils {
    public static Object getTarget(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return AopTargetUtils.getProxyTargetObject(proxy, "h");
        }
        return AopTargetUtils.getProxyTargetObject(proxy, "CGLIB$CALLBACK_0");
    }

    private static Object getProxyTargetObject(Object proxy, String proxyType) {
        Field h;
        try {
            h = proxy.getClass().getSuperclass().getDeclaredField(proxyType);
        }
        catch (NoSuchFieldException ex) {
            return AopTargetUtils.getProxyTargetObjectForCglibAndSpring4(proxy);
        }
        h.setAccessible(true);
        try {
            return AopTargetUtils.getTargetObject(h.get(proxy));
        }
        catch (IllegalAccessException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private static Object getProxyTargetObjectForCglibAndSpring4(Object proxy) {
        try {
            Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
            h.setAccessible(true);
            Object dynamicAdvisedInterceptor = h.get(proxy);
            Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        }
        catch (Exception ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private static Object getTargetObject(Object object) {
        try {
            Field advised = object.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return ((AdvisedSupport)advised.get(object)).getTargetSource().getTarget();
        }
        catch (Exception ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private AopTargetUtils() {
    }
}

