/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.spring.namespace.parser;

import com.dangdang.ddframe.rdb.sharding.api.strategy.slave.MasterSlaveLoadBalanceStrategyType;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource.MasterSlaveDataSource;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class MasterSlaveDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(MasterSlaveDataSource.class);
        factory.addConstructorArgValue((Object)this.parseId(element));
        String masterDataSourceName = this.parseMasterDataSourceRef(element);
        factory.addConstructorArgValue((Object)masterDataSourceName);
        factory.addConstructorArgReference(masterDataSourceName);
        factory.addConstructorArgValue(this.parseSlaveDataSources(element, parserContext));
        String strategyRef = this.parseStrategyRef(element);
        if (!Strings.isNullOrEmpty((String)strategyRef)) {
            factory.addConstructorArgReference(strategyRef);
        } else {
            factory.addConstructorArgValue((Object)this.parseStrategyType(element));
        }
        return factory.getBeanDefinition();
    }

    private String parseId(Element element) {
        return element.getAttribute("id");
    }

    private String parseMasterDataSourceRef(Element element) {
        return element.getAttribute("master-data-source-ref");
    }

    private Map<String, BeanDefinition> parseSlaveDataSources(Element element, ParserContext parserContext) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("slave-data-sources-ref"));
        ManagedMap result = new ManagedMap(slaveDataSources.size());
        for (String each : slaveDataSources) {
            result.put(each, parserContext.getRegistry().getBeanDefinition(each));
        }
        return result;
    }

    private String parseStrategyRef(Element element) {
        return element.getAttribute("strategy-ref");
    }

    private MasterSlaveLoadBalanceStrategyType parseStrategyType(Element element) {
        String result = element.getAttribute("strategy-type");
        return Strings.isNullOrEmpty((String)result) ? MasterSlaveLoadBalanceStrategyType.getDefaultStrategyType() : MasterSlaveLoadBalanceStrategyType.valueOf((String)result);
    }
}

