/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEventBus;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEventBus;
import com.dangdang.ddframe.rdb.sharding.executor.event.EventExecutionType;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.AbstractExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.BatchPreparedStatementExecutorWrapper;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;

class EventPostman {
    private final Collection<? extends AbstractExecutorWrapper> statementExecutorWrappers;

    void postExecutionEvents() {
        for (AbstractExecutorWrapper abstractExecutorWrapper : this.statementExecutorWrappers) {
            if (abstractExecutorWrapper.getDMLExecutionEvent().isPresent()) {
                DMLExecutionEventBus.post((DMLExecutionEvent)abstractExecutorWrapper.getDMLExecutionEvent().get());
                continue;
            }
            if (!abstractExecutorWrapper.getDQLExecutionEvent().isPresent()) continue;
            DQLExecutionEventBus.post((DQLExecutionEvent)abstractExecutorWrapper.getDQLExecutionEvent().get());
        }
    }

    void postExecutionEventsAfterExecution(AbstractExecutorWrapper statementExecutorWrapper) {
        this.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_SUCCESS, (Optional<SQLException>)Optional.absent());
    }

    void postExecutionEventsAfterExecution(AbstractExecutorWrapper statementExecutorWrapper, EventExecutionType eventExecutionType, Optional<SQLException> exp) {
        if (statementExecutorWrapper.getDMLExecutionEvent().isPresent()) {
            DMLExecutionEvent event = (DMLExecutionEvent)statementExecutorWrapper.getDMLExecutionEvent().get();
            event.setEventExecutionType(eventExecutionType);
            event.setExp(exp);
            DMLExecutionEventBus.post(event);
        } else if (statementExecutorWrapper.getDQLExecutionEvent().isPresent()) {
            DQLExecutionEvent event = (DQLExecutionEvent)statementExecutorWrapper.getDQLExecutionEvent().get();
            event.setEventExecutionType(eventExecutionType);
            event.setExp(exp);
            DQLExecutionEventBus.post(event);
        }
    }

    void postBatchExecutionEventsAfterExecution(BatchPreparedStatementExecutorWrapper batchPreparedStatementExecutorWrapper) {
        this.postBatchExecutionEventsAfterExecution(batchPreparedStatementExecutorWrapper, EventExecutionType.EXECUTE_SUCCESS, (Optional<SQLException>)Optional.absent());
    }

    void postBatchExecutionEventsAfterExecution(BatchPreparedStatementExecutorWrapper batchPreparedStatementExecutorWrapper, EventExecutionType eventExecutionType, Optional<SQLException> exp) {
        for (DMLExecutionEvent each : batchPreparedStatementExecutorWrapper.getDmlExecutionEvents()) {
            each.setEventExecutionType(eventExecutionType);
            each.setExp(exp);
            DMLExecutionEventBus.post(each);
        }
    }

    @ConstructorProperties(value={"statementExecutorWrappers"})
    public EventPostman(Collection<? extends AbstractExecutorWrapper> statementExecutorWrappers) {
        this.statementExecutorWrappers = statementExecutorWrappers;
    }
}

