/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.dangdang.ddframe.rdb.sharding.config.ShardingProperties;
import com.dangdang.ddframe.rdb.sharding.config.ShardingPropertiesConstant;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorExceptionHandler;
import com.dangdang.ddframe.rdb.sharding.executor.MergeUnit;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorEngine {
    private static final Logger log = LoggerFactory.getLogger(ExecutorEngine.class);
    private final ListeningExecutorService executorService;

    public ExecutorEngine(ShardingProperties shardingProperties) {
        int executorMinIdleSize = (Integer)shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_MIN_IDLE_SIZE);
        int executorMaxSize = (Integer)shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_MAX_SIZE);
        long executorMaxIdleTimeoutMilliseconds = (Long)shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_MAX_IDLE_TIMEOUT_MILLISECONDS);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor(executorMinIdleSize, executorMaxSize, executorMaxIdleTimeoutMilliseconds, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>())));
    }

    public <I, O> List<O> execute(Collection<I> inputs, ExecuteUnit<I, O> executeUnit) {
        ListenableFuture<List<O>> futures = this.submitFutures(inputs, executeUnit);
        this.addCallback(futures);
        return this.getFutureResults(futures);
    }

    public <I, M, O> O execute(Collection<I> inputs, ExecuteUnit<I, M> executeUnit, MergeUnit<M, O> mergeUnit) {
        return mergeUnit.merge(this.execute(inputs, executeUnit));
    }

    public void shutdown() {
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.executorService.isTerminated()) {
            throw new ShardingJdbcException("ExecutorEngine can not been terminated", new Object[0]);
        }
    }

    private <I, O> ListenableFuture<List<O>> submitFutures(Collection<I> inputs, final ExecuteUnit<I, O> executeUnit) {
        HashSet<ListenableFuture> result = new HashSet<ListenableFuture>(inputs.size());
        for (final I each : inputs) {
            result.add(this.executorService.submit(new Callable<O>(){

                @Override
                public O call() throws Exception {
                    return executeUnit.execute(each);
                }
            }));
        }
        return Futures.allAsList(result);
    }

    private <T> void addCallback(ListenableFuture<T> allFutures) {
        Futures.addCallback(allFutures, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                log.trace("Concurrent execute result success {}", result);
            }

            public void onFailure(Throwable thrown) {
                log.error("Concurrent execute result error {}", thrown);
            }
        });
    }

    private <O> O getFutureResults(ListenableFuture<O> futures) {
        try {
            return (O)futures.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
    }
}

