/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.event;

import com.dangdang.ddframe.rdb.sharding.executor.event.EventExecutionType;
import com.google.common.base.Optional;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class ExecutionEvent {
    private final String id;
    private final String dataSource;
    private final String sql;
    private final List<Object> parameters;
    private EventExecutionType eventExecutionType = EventExecutionType.BEFORE_EXECUTE;
    private Optional<SQLException> exp;

    ExecutionEvent(String dataSource, String sql) {
        this(dataSource, sql, Collections.emptyList());
    }

    ExecutionEvent(String dataSource, String sql, List<Object> parameters) {
        this.id = UUID.randomUUID().toString();
        this.dataSource = dataSource;
        this.sql = sql;
        this.parameters = parameters;
    }

    public String getId() {
        return this.id;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public EventExecutionType getEventExecutionType() {
        return this.eventExecutionType;
    }

    public Optional<SQLException> getExp() {
        return this.exp;
    }

    public void setEventExecutionType(EventExecutionType eventExecutionType) {
        this.eventExecutionType = eventExecutionType;
    }

    public void setExp(Optional<SQLException> exp) {
        this.exp = exp;
    }
}

