/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.wrapper;

import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.AbstractExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.util.List;

public class PreparedStatementExecutorWrapper
extends AbstractExecutorWrapper {
    private final PreparedStatement preparedStatement;
    private final Optional<DMLExecutionEvent> dmlExecutionEvent;
    private final Optional<DQLExecutionEvent> dqlExecutionEvent;

    public PreparedStatementExecutorWrapper(PreparedStatement preparedStatement, List<Object> parameters, SQLExecutionUnit sqlExecutionUnit) {
        super(sqlExecutionUnit);
        this.preparedStatement = preparedStatement;
        if (this.isDML()) {
            this.dmlExecutionEvent = Optional.of((Object)new DMLExecutionEvent(this.getSqlExecutionUnit().getDataSource(), this.getSqlExecutionUnit().getSql(), Lists.newArrayList(parameters)));
            this.dqlExecutionEvent = Optional.absent();
        } else if (this.isDQL()) {
            this.dqlExecutionEvent = Optional.of((Object)new DQLExecutionEvent(this.getSqlExecutionUnit().getDataSource(), this.getSqlExecutionUnit().getSql(), Lists.newArrayList(parameters)));
            this.dmlExecutionEvent = Optional.absent();
        } else {
            this.dmlExecutionEvent = Optional.absent();
            this.dqlExecutionEvent = Optional.absent();
        }
    }

    @Override
    public Optional<DMLExecutionEvent> getDMLExecutionEvent() {
        return this.dmlExecutionEvent;
    }

    @Override
    public Optional<DQLExecutionEvent> getDQLExecutionEvent() {
        return this.dqlExecutionEvent;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }
}

