/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger;

import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractResultSetAdapter;
import com.dangdang.ddframe.rdb.sharding.merger.ShardingResultSets;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.AggregationColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.GroupByColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.IndexColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.MergeContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.OrderByColumn;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ResultSetMergeContext {
    private final ShardingResultSets shardingResultSets;
    private final MergeContext mergeContext;
    private final List<OrderByColumn> currentOrderByKeys;

    public ResultSetMergeContext(ShardingResultSets shardingResultSets, MergeContext mergeContext) throws SQLException {
        this.shardingResultSets = shardingResultSets;
        this.mergeContext = mergeContext;
        this.currentOrderByKeys = new LinkedList<OrderByColumn>();
        this.init();
    }

    private void init() throws SQLException {
        this.setColumnIndex(((AbstractResultSetAdapter)this.shardingResultSets.getResultSets().get(0)).getColumnLabelIndexMap());
        this.currentOrderByKeys.addAll(this.mergeContext.getOrderByColumns());
    }

    private void setColumnIndex(Map<String, Integer> columnLabelIndexMap) {
        for (IndexColumn each : this.getAllFocusedColumns()) {
            if (each.getColumnIndex() > 0) continue;
            Preconditions.checkState((columnLabelIndexMap.containsKey(each.getColumnLabel().orNull()) || columnLabelIndexMap.containsKey(each.getColumnName().orNull()) ? 1 : 0) != 0, (Object)String.format("%s has not index", each));
            if (each.getColumnLabel().isPresent() && columnLabelIndexMap.containsKey(each.getColumnLabel().get())) {
                each.setColumnIndex(columnLabelIndexMap.get(each.getColumnLabel().get()));
                continue;
            }
            if (!each.getColumnName().isPresent() || !columnLabelIndexMap.containsKey(each.getColumnName().get())) continue;
            each.setColumnIndex(columnLabelIndexMap.get(each.getColumnName().get()));
        }
    }

    private List<IndexColumn> getAllFocusedColumns() {
        LinkedList<IndexColumn> result = new LinkedList<IndexColumn>();
        result.addAll(this.mergeContext.getGroupByColumns());
        result.addAll(this.mergeContext.getOrderByColumns());
        LinkedList allAggregationColumns = Lists.newLinkedList(this.mergeContext.getAggregationColumns());
        while (!allAggregationColumns.isEmpty()) {
            AggregationColumn firstElement = (AggregationColumn)allAggregationColumns.poll();
            result.add(firstElement);
            if (firstElement.getDerivedColumns().isEmpty()) continue;
            allAggregationColumns.addAll(firstElement.getDerivedColumns());
        }
        return result;
    }

    public boolean isNeedMemorySortForGroupBy() {
        return this.mergeContext.hasGroupBy() && !this.currentOrderByKeys.equals(this.transformGroupByColumnsToOrderByColumns());
    }

    public void setGroupByKeysToCurrentOrderByKeys() {
        this.currentOrderByKeys.clear();
        this.currentOrderByKeys.addAll(this.transformGroupByColumnsToOrderByColumns());
    }

    private List<OrderByColumn> transformGroupByColumnsToOrderByColumns() {
        return Lists.transform(this.mergeContext.getGroupByColumns(), (Function)new Function<GroupByColumn, OrderByColumn>(){

            public OrderByColumn apply(GroupByColumn input) {
                OrderByColumn result = new OrderByColumn(input.getOwner(), (String)input.getName().get(), input.getAlias(), input.getOrderByType());
                result.setColumnIndex(input.getColumnIndex());
                return result;
            }
        });
    }

    public boolean isNeedMemorySortForOrderBy() {
        return this.mergeContext.hasOrderBy() && !this.currentOrderByKeys.equals(this.mergeContext.getOrderByColumns());
    }

    public void setOrderByKeysToCurrentOrderByKeys() {
        this.currentOrderByKeys.clear();
        this.currentOrderByKeys.addAll(this.mergeContext.getOrderByColumns());
    }

    public ShardingResultSets getShardingResultSets() {
        return this.shardingResultSets;
    }

    public MergeContext getMergeContext() {
        return this.mergeContext;
    }

    public List<OrderByColumn> getCurrentOrderByKeys() {
        return this.currentOrderByKeys;
    }
}

