/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.parser.result.GeneratedKeyContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.AbstractMySQLVisitor;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;

public class MySQLInsertVisitor
extends AbstractMySQLVisitor {
    public boolean visit(MySqlInsertStatement x) {
        String tableName = SQLUtil.getExactlyValue(x.getTableName().toString());
        this.getParseContext().setCurrentTable(tableName, (Optional<String>)Optional.fromNullable((Object)x.getAlias()));
        if (null == x.getValues()) {
            return super.visit(x);
        }
        Collection<String> autoIncrementColumns = this.getParseContext().getShardingRule().getAutoIncrementColumns(tableName);
        List columns = x.getColumns();
        List values = x.getValues().getValues();
        for (int i = 0; i < x.getColumns().size(); ++i) {
            String columnName = SQLUtil.getExactlyValue(((SQLExpr)columns.get(i)).toString());
            this.getParseContext().addCondition(columnName, tableName, Condition.BinaryOperator.EQUAL, (SQLExpr)values.get(i), this.getDatabaseType(), this.getParameters());
            if (!autoIncrementColumns.contains(columnName)) continue;
            autoIncrementColumns.remove(columnName);
        }
        if (autoIncrementColumns.isEmpty()) {
            return super.visit(x);
        }
        this.supplyAutoIncrementColumn(autoIncrementColumns, tableName, columns, values);
        return super.visit(x);
    }

    private void supplyAutoIncrementColumn(Collection<String> autoIncrementColumns, String tableName, List<SQLExpr> columns, List<SQLExpr> values) {
        boolean isPreparedStatement = !this.getParameters().isEmpty();
        GeneratedKeyContext generatedKeyContext = this.getParseContext().getParsedResult().getGeneratedKeyContext();
        if (isPreparedStatement) {
            generatedKeyContext.getColumns().addAll(autoIncrementColumns);
        }
        TableRule tableRule = this.getParseContext().getShardingRule().findTableRule(tableName);
        for (String each : autoIncrementColumns) {
            SQLVariantRefExpr sqlExpr;
            Object id = tableRule.generateId(each);
            generatedKeyContext.putValue(each, id);
            if (isPreparedStatement) {
                sqlExpr = new SQLVariantRefExpr("?");
                this.getParameters().add(id);
                sqlExpr.setIndex(this.getParametersSize() - 1);
            } else {
                sqlExpr = id instanceof Number ? new SQLNumberExpr((Number)id) : new SQLCharExpr((String)id);
            }
            this.getParseContext().addCondition(each, tableName, Condition.BinaryOperator.EQUAL, (SQLExpr)sqlExpr, this.getDatabaseType(), this.getParameters());
            columns.add((SQLExpr)new SQLIdentifierExpr(each));
            values.add((SQLExpr)sqlExpr);
        }
    }
}

