/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.single;

import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.router.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingDataSource;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingTableFactor;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingleRoutingResult
implements RoutingResult {
    private final List<SingleRoutingDataSource> routingDataSources = new ArrayList<SingleRoutingDataSource>();

    void put(String dataSourceName, SingleRoutingTableFactor routingTableFactor) {
        for (SingleRoutingDataSource each : this.routingDataSources) {
            if (!each.getDataSource().equals(dataSourceName)) continue;
            each.getRoutingTableFactors().add(routingTableFactor);
            return;
        }
        this.routingDataSources.add(new SingleRoutingDataSource(dataSourceName, routingTableFactor));
    }

    public Map<String, Set<String>> getDataSourceLogicTablesMap(Collection<String> dataSources) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (SingleRoutingDataSource each : this.routingDataSources) {
            Set<String> logicTables;
            if (!dataSources.contains(each.getDataSource()) || (logicTables = each.getLogicTables()).isEmpty()) continue;
            if (result.containsKey(each.getDataSource())) {
                ((Set)result.get(each.getDataSource())).addAll(logicTables);
                continue;
            }
            result.put(each.getDataSource(), logicTables);
        }
        return result;
    }

    public Collection<String> getDataSources() {
        return Lists.transform(this.routingDataSources, (Function)new Function<SingleRoutingDataSource, String>(){

            public String apply(SingleRoutingDataSource input) {
                return input.getDataSource();
            }
        });
    }

    public List<Set<String>> getActualTableGroups(String dataSource, Set<String> logicTables) {
        Optional<SingleRoutingDataSource> routingDataSource = this.findRoutingDataSource(dataSource);
        if (!routingDataSource.isPresent()) {
            return Collections.emptyList();
        }
        return ((SingleRoutingDataSource)routingDataSource.get()).getActualTableGroups(logicTables);
    }

    public Optional<SingleRoutingTableFactor> findRoutingTableFactor(String dataSource, String actualTable) {
        Optional<SingleRoutingDataSource> routingDataSource = this.findRoutingDataSource(dataSource);
        if (!routingDataSource.isPresent()) {
            return Optional.absent();
        }
        return ((SingleRoutingDataSource)routingDataSource.get()).findRoutingTableFactor(actualTable);
    }

    private Optional<SingleRoutingDataSource> findRoutingDataSource(String dataSource) {
        for (SingleRoutingDataSource each : this.routingDataSources) {
            if (!each.getDataSource().equals(dataSource)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    @Override
    public Collection<SQLExecutionUnit> getSQLExecutionUnits(SQLBuilder sqlBuilder) {
        ArrayList<SQLExecutionUnit> result = new ArrayList<SQLExecutionUnit>();
        for (SingleRoutingDataSource each : this.routingDataSources) {
            result.addAll(each.getSQLExecutionUnits(sqlBuilder));
        }
        return result;
    }

    public String toString() {
        return "SingleRoutingResult(routingDataSources=" + this.getRoutingDataSources() + ")";
    }

    public List<SingleRoutingDataSource> getRoutingDataSources() {
        return this.routingDataSources;
    }
}

