/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api.rule;

import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;

public final class BindingTableRule {
    private final List<TableRule> tableRules;

    public boolean hasLogicTable(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equals(logicTableName)) continue;
            return true;
        }
        return false;
    }

    public String getBindingActualTable(String dataSource, String logicTable, String otherActualTable) {
        int index = -1;
        for (TableRule each : this.tableRules) {
            if (each.isDynamic()) {
                throw new UnsupportedOperationException("Dynamic table cannot support Binding table.");
            }
            index = each.findActualTableIndex(dataSource, otherActualTable);
            if (-1 == index) continue;
            break;
        }
        Preconditions.checkState((-1 != index ? 1 : 0) != 0, (Object)String.format("Actual table [%s].[%s] is not in table config", dataSource, otherActualTable));
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equals(logicTable)) continue;
            return each.getActualTables().get(index).getTableName();
        }
        throw new IllegalStateException(String.format("Cannot find binding actual table, data source: %s, logic table: %s, other actual table: %s", dataSource, logicTable, otherActualTable));
    }

    Collection<String> getAllLogicTables() {
        return Lists.transform(this.tableRules, (Function)new Function<TableRule, String>(){

            public String apply(TableRule input) {
                return input.getLogicTable();
            }
        });
    }

    @ConstructorProperties(value={"tableRules"})
    public BindingTableRule(List<TableRule> tableRules) {
        this.tableRules = tableRules;
    }

    public List<TableRule> getTableRules() {
        return this.tableRules;
    }
}

