/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.result.merger;

import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import java.util.List;

public class Limit {
    public static final String OFFSET_NAME = "limit_offset";
    public static final String COUNT_NAME = "limit_count";
    private final int offset;
    private final int rowCount;
    private final int offsetParameterIndex;
    private final int rowCountParameterIndex;
    private final int multiShardingOffset;
    private final int multiShardingRowCount;

    public Limit(int offset, int rowCount, int offsetParameterIndex, int rowCountParameterIndex) {
        this.offset = offset;
        this.rowCount = rowCount;
        this.offsetParameterIndex = offsetParameterIndex;
        this.rowCountParameterIndex = rowCountParameterIndex;
        this.multiShardingOffset = 0;
        this.multiShardingRowCount = offset + rowCount;
    }

    public void replaceSQL(SQLBuilder sqlBuilder, boolean isVarious) {
        if (!isVarious) {
            return;
        }
        sqlBuilder.buildSQL(OFFSET_NAME, String.valueOf(this.multiShardingOffset));
        sqlBuilder.buildSQL(COUNT_NAME, String.valueOf(this.multiShardingRowCount));
    }

    public void replaceParameters(List<Object> parameters, boolean isVarious) {
        if (this.offsetParameterIndex > -1) {
            parameters.set(this.offsetParameterIndex, isVarious ? this.multiShardingOffset : this.offset);
        }
        if (this.rowCountParameterIndex > -1) {
            parameters.set(this.rowCountParameterIndex, isVarious ? this.multiShardingRowCount : this.rowCount);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getOffsetParameterIndex() {
        return this.offsetParameterIndex;
    }

    public int getRowCountParameterIndex() {
        return this.rowCountParameterIndex;
    }

    public int getMultiShardingOffset() {
        return this.multiShardingOffset;
    }

    public int getMultiShardingRowCount() {
        return this.multiShardingRowCount;
    }

    public String toString() {
        return "Limit(offset=" + this.getOffset() + ", rowCount=" + this.getRowCount() + ", offsetParameterIndex=" + this.getOffsetParameterIndex() + ", rowCountParameterIndex=" + this.getRowCountParameterIndex() + ", multiShardingOffset=" + this.getMultiShardingOffset() + ", multiShardingRowCount=" + this.getMultiShardingRowCount() + ")";
    }
}

