/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.executor.BaseStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteCallback;
import com.dangdang.ddframe.rdb.sharding.executor.event.AbstractExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.EventExecutionType;
import com.dangdang.ddframe.rdb.sharding.executor.threadlocal.ExecutorDataMap;
import com.dangdang.ddframe.rdb.sharding.executor.threadlocal.ExecutorExceptionHandler;
import com.dangdang.ddframe.rdb.sharding.executor.type.batch.BatchPreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.type.prepared.PreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.type.statement.StatementUnit;
import com.dangdang.ddframe.rdb.sharding.util.EventBusInstance;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorEngine
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ExecutorEngine.class);
    private final ListeningExecutorService executorService;

    public ExecutorEngine(int executorSize) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(executorSize, executorSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShardingJDBC-%d").build()));
        MoreExecutors.addDelayedShutdownHook((ExecutorService)this.executorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public <T> List<T> executeStatement(SQLType sqlType, Collection<StatementUnit> statementUnits, ExecuteCallback<T> executeCallback) {
        return this.execute(sqlType, statementUnits, Collections.emptyList(), executeCallback);
    }

    public <T> List<T> executePreparedStatement(SQLType sqlType, Collection<PreparedStatementUnit> preparedStatementUnits, List<Object> parameters, ExecuteCallback<T> executeCallback) {
        return this.execute(sqlType, preparedStatementUnits, Collections.singletonList(parameters), executeCallback);
    }

    public List<int[]> executeBatch(SQLType sqlType, Collection<BatchPreparedStatementUnit> batchPreparedStatementUnits, List<List<Object>> parameterSets, ExecuteCallback<int[]> executeCallback) {
        return this.execute(sqlType, batchPreparedStatementUnits, parameterSets, executeCallback);
    }

    private <T> List<T> execute(SQLType sqlType, Collection<? extends BaseStatementUnit> baseStatementUnits, List<List<Object>> parameterSets, ExecuteCallback<T> executeCallback) {
        List restOutputs;
        T firstOutput;
        if (baseStatementUnits.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<? extends BaseStatementUnit> iterator = baseStatementUnits.iterator();
        BaseStatementUnit firstInput = iterator.next();
        ListenableFuture<List<T>> restFutures = this.asyncExecute(sqlType, Lists.newArrayList(iterator), parameterSets, executeCallback);
        try {
            firstOutput = this.syncExecute(sqlType, firstInput, parameterSets, executeCallback);
            restOutputs = (List)restFutures.get();
        }
        catch (Exception ex) {
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
        LinkedList result = Lists.newLinkedList((Iterable)restOutputs);
        result.add(0, firstOutput);
        return result;
    }

    private <T> ListenableFuture<List<T>> asyncExecute(final SQLType sqlType, Collection<BaseStatementUnit> baseStatementUnits, final List<List<Object>> parameterSets, final ExecuteCallback<T> executeCallback) {
        ArrayList<ListenableFuture> result = new ArrayList<ListenableFuture>(baseStatementUnits.size());
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        for (final BaseStatementUnit each : baseStatementUnits) {
            result.add(this.executorService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return ExecutorEngine.this.executeInternal(sqlType, each, parameterSets, executeCallback, isExceptionThrown, dataMap);
                }
            }));
        }
        return Futures.allAsList(result);
    }

    private <T> T syncExecute(SQLType sqlType, BaseStatementUnit baseStatementUnit, List<List<Object>> parameterSets, ExecuteCallback<T> executeCallback) throws Exception {
        return this.executeInternal(sqlType, baseStatementUnit, parameterSets, executeCallback, ExecutorExceptionHandler.isExceptionThrown(), ExecutorDataMap.getDataMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeInternal(SQLType sqlType, BaseStatementUnit baseStatementUnit, List<List<Object>> parameterSets, ExecuteCallback<T> executeCallback, boolean isExceptionThrown, Map<String, Object> dataMap) throws Exception {
        Connection connection = baseStatementUnit.getStatement().getConnection();
        synchronized (connection) {
            T result;
            ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
            ExecutorDataMap.setDataMap(dataMap);
            LinkedList<AbstractExecutionEvent> events = new LinkedList<AbstractExecutionEvent>();
            if (parameterSets.isEmpty()) {
                events.add(this.getExecutionEvent(sqlType, baseStatementUnit, Collections.emptyList()));
            }
            for (List<Object> list : parameterSets) {
                events.add(this.getExecutionEvent(sqlType, baseStatementUnit, list));
            }
            for (AbstractExecutionEvent abstractExecutionEvent : events) {
                EventBusInstance.getInstance().post((Object)abstractExecutionEvent);
            }
            try {
                result = executeCallback.execute(baseStatementUnit);
            }
            catch (SQLException ex) {
                for (AbstractExecutionEvent each : events) {
                    each.setEventExecutionType(EventExecutionType.EXECUTE_FAILURE);
                    each.setException((Optional<SQLException>)Optional.of((Object)ex));
                    EventBusInstance.getInstance().post((Object)each);
                    ExecutorExceptionHandler.handleException(ex);
                }
                return null;
            }
            for (AbstractExecutionEvent abstractExecutionEvent : events) {
                abstractExecutionEvent.setEventExecutionType(EventExecutionType.EXECUTE_SUCCESS);
                EventBusInstance.getInstance().post((Object)abstractExecutionEvent);
            }
            return result;
        }
    }

    private AbstractExecutionEvent getExecutionEvent(SQLType sqlType, BaseStatementUnit baseStatementUnit, List<Object> parameters) {
        AbstractExecutionEvent result = SQLType.SELECT == sqlType ? new DQLExecutionEvent(baseStatementUnit.getSqlExecutionUnit().getDataSource(), baseStatementUnit.getSqlExecutionUnit().getSql(), parameters) : new DMLExecutionEvent(baseStatementUnit.getSqlExecutionUnit().getDataSource(), baseStatementUnit.getSqlExecutionUnit().getSql(), parameters);
        return result;
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.executorService.isTerminated()) {
            throw new ShardingJdbcException("ExecutorEngine can not been terminated", new Object[0]);
        }
    }
}

