/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.common;

import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMerger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class AbstractStreamResultSetMerger
implements ResultSetMerger {
    private ResultSet currentResultSet;

    protected ResultSet getCurrentResultSet() throws SQLException {
        if (null == this.currentResultSet) {
            throw new SQLException("Current ResultSet is null, ResultSet perhaps end of next.");
        }
        return this.currentResultSet;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Object.class == type) {
            return this.getCurrentResultSet().getObject(columnIndex);
        }
        if (Boolean.TYPE == type) {
            return this.getCurrentResultSet().getBoolean(columnIndex);
        }
        if (Byte.TYPE == type) {
            return this.getCurrentResultSet().getByte(columnIndex);
        }
        if (Short.TYPE == type) {
            return this.getCurrentResultSet().getShort(columnIndex);
        }
        if (Integer.TYPE == type) {
            return this.getCurrentResultSet().getInt(columnIndex);
        }
        if (Long.TYPE == type) {
            return this.getCurrentResultSet().getLong(columnIndex);
        }
        if (Float.TYPE == type) {
            return Float.valueOf(this.getCurrentResultSet().getFloat(columnIndex));
        }
        if (Double.TYPE == type) {
            return this.getCurrentResultSet().getDouble(columnIndex);
        }
        if (String.class == type) {
            return this.getCurrentResultSet().getString(columnIndex);
        }
        if (BigDecimal.class == type) {
            return this.getCurrentResultSet().getBigDecimal(columnIndex);
        }
        if (byte[].class == type) {
            return this.getCurrentResultSet().getBytes(columnIndex);
        }
        if (Date.class == type) {
            return this.getCurrentResultSet().getDate(columnIndex);
        }
        if (Time.class == type) {
            return this.getCurrentResultSet().getTime(columnIndex);
        }
        if (Timestamp.class == type) {
            return this.getCurrentResultSet().getTimestamp(columnIndex);
        }
        if (URL.class == type) {
            return this.getCurrentResultSet().getURL(columnIndex);
        }
        if (Blob.class == type) {
            return this.getCurrentResultSet().getBlob(columnIndex);
        }
        if (Clob.class == type) {
            return this.getCurrentResultSet().getClob(columnIndex);
        }
        if (SQLXML.class == type) {
            return this.getCurrentResultSet().getSQLXML(columnIndex);
        }
        if (Reader.class == type) {
            return this.getCurrentResultSet().getCharacterStream(columnIndex);
        }
        return this.getCurrentResultSet().getObject(columnIndex);
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) throws SQLException {
        if (Object.class == type) {
            return this.getCurrentResultSet().getObject(columnLabel);
        }
        if (Boolean.TYPE == type) {
            return this.getCurrentResultSet().getBoolean(columnLabel);
        }
        if (Byte.TYPE == type) {
            return this.getCurrentResultSet().getByte(columnLabel);
        }
        if (Short.TYPE == type) {
            return this.getCurrentResultSet().getShort(columnLabel);
        }
        if (Integer.TYPE == type) {
            return this.getCurrentResultSet().getInt(columnLabel);
        }
        if (Long.TYPE == type) {
            return this.getCurrentResultSet().getLong(columnLabel);
        }
        if (Float.TYPE == type) {
            return Float.valueOf(this.getCurrentResultSet().getFloat(columnLabel));
        }
        if (Double.TYPE == type) {
            return this.getCurrentResultSet().getDouble(columnLabel);
        }
        if (String.class == type) {
            return this.getCurrentResultSet().getString(columnLabel);
        }
        if (BigDecimal.class == type) {
            return this.getCurrentResultSet().getBigDecimal(columnLabel);
        }
        if (byte[].class == type) {
            return this.getCurrentResultSet().getBytes(columnLabel);
        }
        if (Date.class == type) {
            return this.getCurrentResultSet().getDate(columnLabel);
        }
        if (Time.class == type) {
            return this.getCurrentResultSet().getTime(columnLabel);
        }
        if (Timestamp.class == type) {
            return this.getCurrentResultSet().getTimestamp(columnLabel);
        }
        if (URL.class == type) {
            return this.getCurrentResultSet().getURL(columnLabel);
        }
        if (Blob.class == type) {
            return this.getCurrentResultSet().getBlob(columnLabel);
        }
        if (Clob.class == type) {
            return this.getCurrentResultSet().getClob(columnLabel);
        }
        if (SQLXML.class == type) {
            return this.getCurrentResultSet().getSQLXML(columnLabel);
        }
        if (Reader.class == type) {
            return this.getCurrentResultSet().getCharacterStream(columnLabel);
        }
        return this.getCurrentResultSet().getObject(columnLabel);
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        if (Date.class == type) {
            return this.getCurrentResultSet().getDate(columnIndex, calendar);
        }
        if (Time.class == type) {
            return this.getCurrentResultSet().getTime(columnIndex, calendar);
        }
        if (Timestamp.class == type) {
            return this.getCurrentResultSet().getTimestamp(columnIndex, calendar);
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) throws SQLException {
        if (Date.class == type) {
            return this.getCurrentResultSet().getDate(columnLabel, calendar);
        }
        if (Time.class == type) {
            return this.getCurrentResultSet().getTime(columnLabel, calendar);
        }
        if (Timestamp.class == type) {
            return this.getCurrentResultSet().getTimestamp(columnLabel, calendar);
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        if ("Ascii".equals(type)) {
            return this.getCurrentResultSet().getAsciiStream(columnIndex);
        }
        if ("Unicode".equals(type)) {
            return this.getCurrentResultSet().getUnicodeStream(columnIndex);
        }
        if ("Binary".equals(type)) {
            return this.getCurrentResultSet().getBinaryStream(columnIndex);
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) throws SQLException {
        if ("Ascii".equals(type)) {
            return this.getCurrentResultSet().getAsciiStream(columnLabel);
        }
        if ("Unicode".equals(type)) {
            return this.getCurrentResultSet().getUnicodeStream(columnLabel);
        }
        if ("Binary".equals(type)) {
            return this.getCurrentResultSet().getBinaryStream(columnLabel);
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    public void setCurrentResultSet(ResultSet currentResultSet) {
        this.currentResultSet = currentResultSet;
    }
}

