/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.orderby;

import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.merger.util.ResultSetUtil;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.OrderItem;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OrderByValue
implements Comparable<OrderByValue> {
    private final ResultSet resultSet;
    private final List<OrderItem> orderByItems;
    private final OrderType nullOrderType;
    private List<Comparable<?>> orderValues;

    public boolean next() throws SQLException {
        boolean result = this.resultSet.next();
        this.orderValues = result ? this.getOrderValues() : Collections.emptyList();
        return result;
    }

    private List<Comparable<?>> getOrderValues() throws SQLException {
        ArrayList result = new ArrayList(this.orderByItems.size());
        for (OrderItem each : this.orderByItems) {
            Object value = this.resultSet.getObject(each.getIndex());
            Preconditions.checkState((null == value || value instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            result.add((Comparable)value);
        }
        return result;
    }

    @Override
    public int compareTo(OrderByValue o) {
        for (int i = 0; i < this.orderByItems.size(); ++i) {
            OrderItem thisOrderBy = this.orderByItems.get(i);
            int result = ResultSetUtil.compareTo(this.orderValues.get(i), o.orderValues.get(i), thisOrderBy.getType(), this.nullOrderType);
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    @ConstructorProperties(value={"resultSet", "orderByItems", "nullOrderType"})
    public OrderByValue(ResultSet resultSet, List<OrderItem> orderByItems, OrderType nullOrderType) {
        this.resultSet = resultSet;
        this.orderByItems = orderByItems;
        this.nullOrderType = nullOrderType;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

