/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.Lexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.TokenType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.HashSet;

public abstract class AbstractParser {
    private final Lexer lexer;
    private int parametersIndex;

    public int increaseParametersIndex() {
        return ++this.parametersIndex;
    }

    public final String skipParentheses() {
        StringBuilder result = new StringBuilder("");
        int count = 0;
        if (Symbol.LEFT_PAREN == this.getLexer().getCurrentToken().getType()) {
            int beginPosition = this.getLexer().getCurrentToken().getEndPosition();
            result.append(Symbol.LEFT_PAREN.getLiterals());
            this.getLexer().nextToken();
            while (true) {
                if (this.equalAny(Symbol.QUESTION)) {
                    this.increaseParametersIndex();
                }
                if (Assist.END == this.getLexer().getCurrentToken().getType() || Symbol.RIGHT_PAREN == this.getLexer().getCurrentToken().getType() && 0 == count) break;
                if (Symbol.LEFT_PAREN == this.getLexer().getCurrentToken().getType()) {
                    ++count;
                } else if (Symbol.RIGHT_PAREN == this.getLexer().getCurrentToken().getType()) {
                    --count;
                }
                this.getLexer().nextToken();
            }
            result.append(this.getLexer().getInput().substring(beginPosition, this.getLexer().getCurrentToken().getEndPosition()));
            this.getLexer().nextToken();
        }
        return result.toString();
    }

    public final void skipUselessParentheses() {
        while (this.skipIfEqual(Symbol.LEFT_PAREN)) {
        }
        while (this.skipIfEqual(Symbol.RIGHT_PAREN)) {
        }
    }

    public final void accept(TokenType tokenType) {
        if (this.lexer.getCurrentToken().getType() != tokenType) {
            throw new SQLParsingException(this.lexer, tokenType);
        }
        this.lexer.nextToken();
    }

    public final boolean equalAny(TokenType ... tokenTypes) {
        for (TokenType each : tokenTypes) {
            if (each != this.lexer.getCurrentToken().getType()) continue;
            return true;
        }
        return false;
    }

    public final boolean skipIfEqual(TokenType ... tokenTypes) {
        if (this.equalAny(tokenTypes)) {
            this.lexer.nextToken();
            return true;
        }
        return false;
    }

    public final void skipAll(TokenType ... tokenTypes) {
        HashSet tokenTypeSet = Sets.newHashSet((Object[])tokenTypes);
        while (tokenTypeSet.contains(this.lexer.getCurrentToken().getType())) {
            this.lexer.nextToken();
        }
    }

    public final void skipUntil(TokenType ... tokenTypes) {
        HashSet tokenTypeSet = Sets.newHashSet((Object[])tokenTypes);
        tokenTypeSet.add(Assist.END);
        while (!tokenTypeSet.contains(this.lexer.getCurrentToken().getType())) {
            this.lexer.nextToken();
        }
    }

    @ConstructorProperties(value={"lexer"})
    public AbstractParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public int getParametersIndex() {
        return this.parametersIndex;
    }

    public void setParametersIndex(int parametersIndex) {
        this.parametersIndex = parametersIndex;
    }
}

