/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.TokenType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIgnoreExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLTextExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.insert.AbstractInsertParser;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.collect.Sets;
import java.util.Set;

public final class MySQLInsertParser
extends AbstractInsertParser {
    public MySQLInsertParser(ShardingRule shardingRule, SQLParser sqlParser) {
        super(shardingRule, sqlParser);
    }

    @Override
    protected void parseCustomizedInsert() {
        this.parseInsertSet();
    }

    private void parseInsertSet() {
        do {
            SQLExpression sqlExpression;
            this.getSqlParser().getLexer().nextToken();
            Column column = new Column(SQLUtil.getExactlyValue(this.getSqlParser().getLexer().getCurrentToken().getLiterals()), this.getInsertStatement().getTables().getSingleTableName());
            this.getSqlParser().getLexer().nextToken();
            this.getSqlParser().accept(Symbol.EQ);
            if (this.getSqlParser().equalAny(Literals.INT)) {
                sqlExpression = new SQLNumberExpression(Integer.parseInt(this.getSqlParser().getLexer().getCurrentToken().getLiterals()));
            } else if (this.getSqlParser().equalAny(Literals.FLOAT)) {
                sqlExpression = new SQLNumberExpression(Double.parseDouble(this.getSqlParser().getLexer().getCurrentToken().getLiterals()));
            } else if (this.getSqlParser().equalAny(Literals.CHARS)) {
                sqlExpression = new SQLTextExpression(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
            } else if (this.getSqlParser().equalAny(DefaultKeyword.NULL)) {
                sqlExpression = new SQLIgnoreExpression();
            } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
                sqlExpression = new SQLPlaceholderExpression(this.getSqlParser().getParametersIndex());
                this.getSqlParser().increaseParametersIndex();
            } else {
                throw new UnsupportedOperationException("");
            }
            this.getSqlParser().getLexer().nextToken();
            if (this.getSqlParser().equalAny(Symbol.COMMA, DefaultKeyword.ON, Assist.END)) {
                this.getInsertStatement().getConditions().add(new Condition(column, sqlExpression), this.getShardingRule());
                continue;
            }
            this.getSqlParser().skipUntil(Symbol.COMMA, DefaultKeyword.ON);
        } while (this.getSqlParser().equalAny(Symbol.COMMA));
    }

    @Override
    protected Set<TokenType> getSkippedKeywordsBetweenTableAndValues() {
        return Sets.newHashSet((Object[])new TokenType[]{MySQLKeyword.PARTITION});
    }

    @Override
    protected Set<TokenType> getValuesKeywords() {
        return Sets.newHashSet((Object[])new TokenType[]{DefaultKeyword.VALUES, MySQLKeyword.VALUE});
    }

    @Override
    protected Set<TokenType> getCustomizedInsertKeywords() {
        return Sets.newHashSet((Object[])new TokenType[]{DefaultKeyword.SET});
    }
}

