/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.oracle.OracleKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.oracle.OracleLexer;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.SelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.SelectStatement;
import com.google.common.base.Optional;

public final class OracleParser
extends SQLParser {
    public OracleParser(String sql, ShardingRule shardingRule) {
        super(new OracleLexer(sql), shardingRule);
    }

    @Override
    public Optional<String> parseAlias() {
        if (this.equalAny(OracleKeyword.CONNECT)) {
            return Optional.absent();
        }
        return super.parseAlias();
    }

    @Override
    protected boolean isRowNumberCondition(SelectStatement selectStatement, String columnLabel) {
        Optional<String> rowNumberAlias = Optional.absent();
        for (SelectItem each : selectStatement.getItems()) {
            if (!each.getAlias().isPresent() || !"rownum".equalsIgnoreCase(each.getExpression())) continue;
            rowNumberAlias = each.getAlias();
        }
        return "rownum".equalsIgnoreCase(columnLabel) || columnLabel.equalsIgnoreCase((String)rowNumberAlias.orNull());
    }
}

