/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.sqlserver.SQLServerKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.LimitValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.CommonSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.SelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.AbstractSelectParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountToken;
import com.google.common.base.Optional;

public class SQLServerSelectParser
extends AbstractSelectParser {
    public SQLServerSelectParser(SQLParser sqlParser) {
        super(sqlParser);
    }

    @Override
    public void query() {
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.SELECT)) {
            this.parseDistinct();
            this.parseTop();
            this.parseSelectList();
        }
        if (this.getSqlParser().equalAny(DefaultKeyword.INTO)) {
            throw new SQLParsingUnsupportedException(this.getSqlParser().getLexer().getCurrentToken().getType());
        }
        this.parseFrom();
        this.parseWhere();
        this.parseGroupBy();
        this.queryRest();
    }

    private void parseTop() {
        LimitValue rowCountValue;
        if (!this.getSqlParser().skipIfEqual(SQLServerKeyword.TOP)) {
            return;
        }
        int beginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
        if (!this.getSqlParser().skipIfEqual(Symbol.LEFT_PAREN)) {
            beginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition() - this.getSqlParser().getLexer().getCurrentToken().getLiterals().length();
        }
        SQLExpression sqlExpression = this.getSqlParser().parseExpression();
        this.getSqlParser().skipIfEqual(Symbol.RIGHT_PAREN);
        if (sqlExpression instanceof SQLNumberExpression) {
            int rowCount = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
            rowCountValue = new LimitValue(rowCount, -1);
            this.getSelectStatement().getSqlTokens().add(new RowCountToken(beginPosition, rowCount));
        } else if (sqlExpression instanceof SQLPlaceholderExpression) {
            rowCountValue = new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex());
        } else {
            throw new SQLParsingException(this.getSqlParser().getLexer());
        }
        if (this.getSqlParser().skipIfEqual(SQLServerKeyword.PERCENT)) {
            return;
        }
        if (null == this.getSelectStatement().getLimit()) {
            Limit limit = new Limit(false);
            limit.setRowCount(rowCountValue);
            this.getSelectStatement().setLimit(limit);
        } else {
            this.getSelectStatement().getLimit().setRowCount(rowCountValue);
        }
    }

    @Override
    protected boolean isRowNumberSelectItem() {
        return this.getSqlParser().getLexer().getCurrentToken().getLiterals().equalsIgnoreCase("ROW_NUMBER");
    }

    @Override
    protected SelectItem parseRowNumberSelectItem() {
        this.getSqlParser().getLexer().nextToken();
        if (this.getSqlParser().equalAny(Symbol.LEFT_PAREN)) {
            this.getSqlParser().skipUntil(DefaultKeyword.OVER);
            this.getSqlParser().getLexer().nextToken();
            this.getSqlParser().skipIfEqual(Symbol.LEFT_PAREN);
            this.parseOrderBy();
            this.getSqlParser().skipIfEqual(Symbol.RIGHT_PAREN);
            this.getSqlParser().skipUntil(DefaultKeyword.AS);
            this.getSqlParser().getLexer().nextToken();
            CommonSelectItem result = new CommonSelectItem("ROW_NUMBER", (Optional<String>)Optional.of((Object)this.getSqlParser().getLexer().getCurrentToken().getLiterals()));
            this.getSqlParser().getLexer().nextToken();
            return result;
        }
        return new CommonSelectItem("ROW_NUMBER", this.getSqlParser().parseAlias());
    }

    @Override
    protected void parseJoinTable() {
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.WITH)) {
            this.getSqlParser().skipParentheses();
        }
        super.parseJoinTable();
    }

    @Override
    protected void customizedSelect() {
        if (this.getSqlParser().equalAny(DefaultKeyword.FOR)) {
            this.parseFor();
        }
        if (this.getSqlParser().equalAny(SQLServerKeyword.OFFSET)) {
            this.parseOffset();
        }
    }

    private void parseOffset() {
        this.getSqlParser().getLexer().nextToken();
        int offsetValue = -1;
        int offsetIndex = -1;
        if (this.getSqlParser().equalAny(Literals.INT)) {
            offsetValue = Integer.parseInt(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
        } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
            offsetIndex = this.getParametersIndex();
            this.getSqlParser().increaseParametersIndex();
        } else {
            throw new SQLParsingException(this.getSqlParser().getLexer());
        }
        this.getSqlParser().getLexer().nextToken();
        Limit limit = new Limit(true);
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.FETCH)) {
            this.getSqlParser().getLexer().nextToken();
            int rowCountValue = -1;
            int rowCountIndex = -1;
            this.getSqlParser().getLexer().nextToken();
            if (this.getSqlParser().equalAny(Literals.INT)) {
                rowCountValue = Integer.parseInt(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
            } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
                rowCountIndex = this.getParametersIndex();
                this.getSqlParser().increaseParametersIndex();
            } else {
                throw new SQLParsingException(this.getSqlParser().getLexer());
            }
            this.getSqlParser().getLexer().nextToken();
            this.getSqlParser().getLexer().nextToken();
            limit.setRowCount(new LimitValue(rowCountValue, rowCountIndex));
            limit.setOffset(new LimitValue(offsetValue, offsetIndex));
        } else {
            limit.setOffset(new LimitValue(offsetValue, offsetIndex));
        }
        this.getSelectStatement().setLimit(limit);
    }

    private void parseFor() {
        block8: {
            this.getSqlParser().getLexer().nextToken();
            if (this.getSqlParser().equalAny(SQLServerKeyword.BROWSE)) {
                this.getSqlParser().getLexer().nextToken();
            } else {
                if (this.getSqlParser().skipIfEqual(SQLServerKeyword.XML)) {
                    while (true) {
                        if (this.getSqlParser().equalAny(SQLServerKeyword.AUTO, SQLServerKeyword.TYPE, SQLServerKeyword.XMLSCHEMA)) {
                            this.getSqlParser().getLexer().nextToken();
                        } else {
                            if (!this.getSqlParser().skipIfEqual(SQLServerKeyword.ELEMENTS)) break block8;
                            this.getSqlParser().skipIfEqual(SQLServerKeyword.XSINIL);
                        }
                        if (this.getSqlParser().equalAny(Symbol.COMMA)) {
                            this.getSqlParser().getLexer().nextToken();
                            continue;
                        }
                        break block8;
                        break;
                    }
                }
                throw new SQLParsingUnsupportedException(this.getSqlParser().getLexer().getCurrentToken().getType());
            }
        }
    }
}

