/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.type.prepared;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.executor.BaseStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteCallback;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.executor.type.prepared.PreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;

public final class PreparedStatementExecutor {
    private final ExecutorEngine executorEngine;
    private final SQLType sqlType;
    private final Collection<PreparedStatementUnit> preparedStatementUnits;
    private final List<Object> parameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSet> executeQuery() {
        List<ResultSet> result;
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeQuery");
        try {
            result = this.executorEngine.executePreparedStatement(this.sqlType, this.preparedStatementUnits, this.parameters, new ExecuteCallback<ResultSet>(){

                @Override
                public ResultSet execute(BaseStatementUnit baseStatementUnit) throws Exception {
                    return ((PreparedStatement)baseStatementUnit.getStatement()).executeQuery();
                }
            });
        }
        finally {
            MetricsContext.stop(context);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeUpdate");
        try {
            List<Integer> results = this.executorEngine.executePreparedStatement(this.sqlType, this.preparedStatementUnits, this.parameters, new ExecuteCallback<Integer>(){

                @Override
                public Integer execute(BaseStatementUnit baseStatementUnit) throws Exception {
                    return ((PreparedStatement)baseStatementUnit.getStatement()).executeUpdate();
                }
            });
            int n = this.accumulate(results);
            return n;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-execute");
        try {
            List<Boolean> result = this.executorEngine.executePreparedStatement(this.sqlType, this.preparedStatementUnits, this.parameters, new ExecuteCallback<Boolean>(){

                @Override
                public Boolean execute(BaseStatementUnit baseStatementUnit) throws Exception {
                    return ((PreparedStatement)baseStatementUnit.getStatement()).execute();
                }
            });
            if (null == result || result.isEmpty() || null == result.get(0)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = result.get(0);
            return bl;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    @ConstructorProperties(value={"executorEngine", "sqlType", "preparedStatementUnits", "parameters"})
    public PreparedStatementExecutor(ExecutorEngine executorEngine, SQLType sqlType, Collection<PreparedStatementUnit> preparedStatementUnits, List<Object> parameters) {
        this.executorEngine = executorEngine;
        this.sqlType = sqlType;
        this.preparedStatementUnits = preparedStatementUnits;
        this.parameters = parameters;
    }
}

