/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.lexer.token;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.TokenType;
import java.util.HashMap;
import java.util.Map;

public enum Symbol implements TokenType
{
    LEFT_PAREN("("),
    RIGHT_PAREN(")"),
    LEFT_BRACE("{"),
    RIGHT_BRACE("}"),
    LEFT_BRACKET("["),
    RIGHT_BRACKET("]"),
    SEMI(";"),
    COMMA(","),
    DOT("."),
    DOUBLE_DOT(".."),
    PLUS("+"),
    SUB("-"),
    STAR("*"),
    SLASH("/"),
    QUESTION("?"),
    EQ("="),
    GT(">"),
    LT("<"),
    BANG("!"),
    TILDE("~"),
    CARET("^"),
    PERCENT("%"),
    COLON(":"),
    DOUBLE_COLON("::"),
    COLON_EQ(":="),
    LT_EQ("<="),
    GT_EQ(">="),
    LT_EQ_GT("<=>"),
    LT_GT("<>"),
    BANG_EQ("!="),
    BANG_GT("!>"),
    BANG_LT("!<"),
    AMP("&"),
    BAR("|"),
    DOUBLE_AMP("&&"),
    DOUBLE_BAR("||"),
    DOUBLE_LT("<<"),
    DOUBLE_GT(">>"),
    MONKEYS_AT("@"),
    POUND("#");

    private static Map<String, Symbol> symbols;
    private final String literals;

    public static Symbol literalsOf(String literals) {
        return symbols.get(literals);
    }

    private Symbol(String literals) {
        this.literals = literals;
    }

    public String getLiterals() {
        return this.literals;
    }

    static {
        symbols = new HashMap<String, Symbol>(128);
        for (Symbol each : Symbol.values()) {
            symbols.put(each.getLiterals(), each);
        }
    }
}

