/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.oracle.OracleKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.AbstractSQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.LimitValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dql.select.AbstractSelectParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountToken;
import java.util.Collection;
import java.util.Collections;

public final class MySQLSelectParser
extends AbstractSelectParser {
    public MySQLSelectParser(AbstractSQLParser sqlParser) {
        super(sqlParser);
    }

    @Override
    protected Collection<Keyword> getCustomizedDistinctKeywords() {
        return Collections.singletonList(MySQLKeyword.DISTINCTROW);
    }

    @Override
    protected void parseBeforeSelectList() {
        this.getSqlParser().skipAll(MySQLKeyword.HIGH_PRIORITY, DefaultKeyword.STRAIGHT_JOIN, MySQLKeyword.SQL_SMALL_RESULT, MySQLKeyword.SQL_BIG_RESULT, MySQLKeyword.SQL_BUFFER_RESULT, MySQLKeyword.SQL_CACHE, MySQLKeyword.SQL_NO_CACHE, MySQLKeyword.SQL_CALC_FOUND_ROWS);
    }

    @Override
    protected void customizedSelect() {
        this.parseLimit();
        if (this.getSqlParser().equalAny(DefaultKeyword.PROCEDURE)) {
            throw new SQLParsingUnsupportedException(this.getSqlParser().getLexer().getCurrentToken().getType());
        }
    }

    private void parseLimit() {
        int value;
        if (!this.getSqlParser().skipIfEqual(MySQLKeyword.LIMIT)) {
            return;
        }
        int valueIndex = -1;
        int valueBeginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
        boolean isParameterForValue = false;
        if (this.getSqlParser().equalAny(Literals.INT)) {
            value = Integer.parseInt(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
            valueBeginPosition -= (value + "").length();
        } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
            valueIndex = this.getParametersIndex();
            value = -1;
            --valueBeginPosition;
            isParameterForValue = true;
        } else {
            throw new SQLParsingException(this.getSqlParser().getLexer());
        }
        this.getSqlParser().getLexer().nextToken();
        if (this.getSqlParser().skipIfEqual(Symbol.COMMA)) {
            this.getSelectStatement().setLimit(this.getLimitWithComma(valueIndex, valueBeginPosition, value, isParameterForValue));
            return;
        }
        if (this.getSqlParser().skipIfEqual(MySQLKeyword.OFFSET)) {
            this.getSelectStatement().setLimit(this.getLimitWithOffset(valueIndex, valueBeginPosition, value, isParameterForValue));
            return;
        }
        if (!isParameterForValue) {
            this.getSelectStatement().getSqlTokens().add(new RowCountToken(valueBeginPosition, value));
        }
        Limit limit = new Limit(true);
        limit.setRowCount(new LimitValue(value, valueIndex));
        this.getSelectStatement().setLimit(limit);
    }

    private Limit getLimitWithComma(int index, int valueBeginPosition, int value, boolean isParameterForValue) {
        int rowCountValue;
        int rowCountBeginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
        int rowCountIndex = -1;
        boolean isParameterForRowCount = false;
        if (this.getSqlParser().equalAny(Literals.INT)) {
            rowCountValue = Integer.parseInt(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
            rowCountBeginPosition -= (rowCountValue + "").length();
        } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
            rowCountIndex = -1 == index ? this.getParametersIndex() : index + 1;
            rowCountValue = -1;
            --rowCountBeginPosition;
            isParameterForRowCount = true;
        } else {
            throw new SQLParsingException(this.getSqlParser().getLexer());
        }
        this.getSqlParser().getLexer().nextToken();
        if (!isParameterForValue) {
            this.getSelectStatement().getSqlTokens().add(new OffsetToken(valueBeginPosition, value));
        }
        if (!isParameterForRowCount) {
            this.getSelectStatement().getSqlTokens().add(new RowCountToken(rowCountBeginPosition, rowCountValue));
        }
        Limit result = new Limit(true);
        result.setRowCount(new LimitValue(rowCountValue, rowCountIndex));
        result.setOffset(new LimitValue(value, index));
        return result;
    }

    private Limit getLimitWithOffset(int index, int valueBeginPosition, int value, boolean isParameterForValue) {
        int offsetBeginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
        int offsetValue = -1;
        int offsetIndex = -1;
        boolean isParameterForOffset = false;
        if (this.getSqlParser().equalAny(Literals.INT)) {
            offsetValue = Integer.parseInt(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
            offsetBeginPosition -= (offsetValue + "").length();
        } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
            offsetIndex = -1 == index ? this.getParametersIndex() : index + 1;
            --offsetBeginPosition;
            isParameterForOffset = true;
        } else {
            throw new SQLParsingException(this.getSqlParser().getLexer());
        }
        this.getSqlParser().getLexer().nextToken();
        if (!isParameterForOffset) {
            this.getSelectStatement().getSqlTokens().add(new OffsetToken(offsetBeginPosition, offsetValue));
        }
        if (!isParameterForValue) {
            this.getSelectStatement().getSqlTokens().add(new RowCountToken(valueBeginPosition, value));
        }
        Limit result = new Limit(true);
        result.setRowCount(new LimitValue(value, index));
        result.setOffset(new LimitValue(offsetValue, offsetIndex));
        return result;
    }

    @Override
    protected void parseJoinTable() {
        if (this.getSqlParser().equalAny(DefaultKeyword.USING)) {
            return;
        }
        if (this.getSqlParser().equalAny(DefaultKeyword.USE)) {
            this.getSqlParser().getLexer().nextToken();
            this.parseIndexHint();
        }
        if (this.getSqlParser().equalAny(OracleKeyword.IGNORE)) {
            this.getSqlParser().getLexer().nextToken();
            this.parseIndexHint();
        }
        if (this.getSqlParser().equalAny(OracleKeyword.FORCE)) {
            this.getSqlParser().getLexer().nextToken();
            this.parseIndexHint();
        }
        super.parseJoinTable();
    }

    private void parseIndexHint() {
        if (this.getSqlParser().equalAny(DefaultKeyword.INDEX)) {
            this.getSqlParser().getLexer().nextToken();
        } else {
            this.getSqlParser().accept(DefaultKeyword.KEY);
        }
        if (this.getSqlParser().equalAny(DefaultKeyword.FOR)) {
            this.getSqlParser().getLexer().nextToken();
            if (this.getSqlParser().equalAny(DefaultKeyword.JOIN)) {
                this.getSqlParser().getLexer().nextToken();
            } else if (this.getSqlParser().equalAny(DefaultKeyword.ORDER)) {
                this.getSqlParser().getLexer().nextToken();
                this.getSqlParser().accept(DefaultKeyword.BY);
            } else {
                this.getSqlParser().accept(DefaultKeyword.GROUP);
                this.getSqlParser().accept(DefaultKeyword.BY);
            }
        }
        this.getSqlParser().skipParentheses();
    }
}

