/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dql.select;

import com.dangdang.ddframe.rdb.sharding.constant.AggregationType;
import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Token;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.AbstractSQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.OrderItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.AggregationSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.CommonSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.SelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table.Table;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIdentifierExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIgnoreExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPropertyExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatementParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dql.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.ItemsToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OrderByToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.TableToken;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSelectParser
implements SQLStatementParser {
    private static final String DERIVED_COUNT_ALIAS = "AVG_DERIVED_COUNT_%s";
    private static final String DERIVED_SUM_ALIAS = "AVG_DERIVED_SUM_%s";
    private static final String ORDER_BY_DERIVED_ALIAS = "ORDER_BY_DERIVED_%s";
    private static final String GROUP_BY_DERIVED_ALIAS = "GROUP_BY_DERIVED_%s";
    private final AbstractSQLParser sqlParser;
    private final SelectStatement selectStatement;
    private int parametersIndex;
    private boolean isInSubQuery;
    private boolean appendDerivedColumnsFlag;

    public AbstractSelectParser(AbstractSQLParser sqlParser) {
        this.sqlParser = sqlParser;
        this.selectStatement = new SelectStatement();
    }

    @Override
    public final SelectStatement parse() {
        this.sqlParser.getLexer().nextToken();
        this.parseDistinct();
        this.parseBeforeSelectList();
        this.parseSelectList();
        this.parseFrom();
        this.parseWhere();
        this.customizedBetweenWhereAndGroupBy();
        this.parseGroupBy();
        this.customizedBetweenGroupByAndOrderBy();
        this.parseOrderBy();
        this.customizedSelect();
        this.processUnsupportedTokens();
        this.appendDerivedColumns();
        this.appendDerivedOrderBy();
        return this.selectStatement;
    }

    private void parseDistinct() {
        this.sqlParser.skipAll(DefaultKeyword.ALL);
        LinkedList distinctKeywords = Lists.newLinkedList(this.getCustomizedDistinctKeywords());
        distinctKeywords.add(DefaultKeyword.DISTINCT);
        if (this.getSqlParser().equalAny(distinctKeywords.toArray(new Keyword[distinctKeywords.size()]))) {
            throw new SQLParsingUnsupportedException(this.getSqlParser().getLexer().getCurrentToken().getType());
        }
    }

    protected Collection<Keyword> getCustomizedDistinctKeywords() {
        return Collections.emptyList();
    }

    protected void parseBeforeSelectList() {
    }

    protected final void parseSelectList() {
        do {
            this.parseSelectItem();
        } while (this.sqlParser.skipIfEqual(Symbol.COMMA));
        if (0 == this.selectStatement.getSelectListLastPosition()) {
            this.selectStatement.setSelectListLastPosition(this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length());
        }
    }

    private void parseSelectItem() {
        if (this.isRowNumberSelectItem()) {
            this.selectStatement.getItems().add(this.parseRowNumberSelectItem());
            return;
        }
        this.sqlParser.skipIfEqual(DefaultKeyword.CONNECT_BY_ROOT);
        String literals = this.sqlParser.getLexer().getCurrentToken().getLiterals();
        if (this.isStarSelectItem(literals)) {
            this.selectStatement.getItems().add(this.parseStarSelectItem());
            return;
        }
        if (this.isAggregationSelectItem()) {
            this.selectStatement.getItems().add(this.parseAggregationSelectItem(literals));
            return;
        }
        StringBuilder expression = new StringBuilder();
        Token lastToken = null;
        while (!(this.sqlParser.equalAny(DefaultKeyword.AS) || this.sqlParser.equalAny(Symbol.COMMA) || this.sqlParser.equalAny(DefaultKeyword.FROM) || this.sqlParser.equalAny(Assist.END))) {
            String value = this.sqlParser.getLexer().getCurrentToken().getLiterals();
            int position = this.sqlParser.getLexer().getCurrentToken().getEndPosition() - value.length();
            expression.append(value);
            lastToken = this.sqlParser.getLexer().getCurrentToken();
            this.sqlParser.getLexer().nextToken();
            if (!this.sqlParser.equalAny(Symbol.DOT)) continue;
            this.selectStatement.getSqlTokens().add(new TableToken(position, value));
        }
        if (this.hasAlias(expression, lastToken)) {
            this.selectStatement.getItems().add(this.parseSelectItemWithAlias(expression, lastToken));
            return;
        }
        this.selectStatement.getItems().add(new CommonSelectItem(SQLUtil.getExactlyValue(expression.toString()), this.sqlParser.parseAlias()));
    }

    protected boolean isRowNumberSelectItem() {
        return false;
    }

    protected SelectItem parseRowNumberSelectItem() {
        throw new UnsupportedOperationException("Cannot support special select item.");
    }

    private boolean isStarSelectItem(String literals) {
        return this.sqlParser.equalAny(Symbol.STAR) || Symbol.STAR.getLiterals().equals(SQLUtil.getExactlyValue(literals));
    }

    private SelectItem parseStarSelectItem() {
        this.sqlParser.getLexer().nextToken();
        this.selectStatement.setContainStar(true);
        return new CommonSelectItem(Symbol.STAR.getLiterals(), this.sqlParser.parseAlias());
    }

    private boolean isAggregationSelectItem() {
        return this.sqlParser.skipIfEqual(DefaultKeyword.MAX, DefaultKeyword.MIN, DefaultKeyword.SUM, DefaultKeyword.AVG, DefaultKeyword.COUNT);
    }

    private SelectItem parseAggregationSelectItem(String literals) {
        return new AggregationSelectItem(AggregationType.valueOf(literals.toUpperCase()), this.sqlParser.skipParentheses(), this.sqlParser.parseAlias());
    }

    private boolean hasAlias(StringBuilder expression, Token lastToken) {
        return null != lastToken && Literals.IDENTIFIER == lastToken.getType() && !this.isSQLPropertyExpression(expression, lastToken) && !expression.toString().equals(lastToken.getLiterals());
    }

    private boolean isSQLPropertyExpression(StringBuilder expression, Token lastToken) {
        return expression.toString().endsWith(Symbol.DOT.getLiterals() + lastToken.getLiterals());
    }

    private CommonSelectItem parseSelectItemWithAlias(StringBuilder expression, Token lastToken) {
        return new CommonSelectItem(SQLUtil.getExactlyValue(expression.substring(0, expression.lastIndexOf(lastToken.getLiterals()))), (Optional<String>)Optional.of((Object)lastToken.getLiterals()));
    }

    protected final void parseWhere() {
        if (this.selectStatement.getTables().isEmpty()) {
            return;
        }
        this.sqlParser.parseWhere(this.selectStatement);
        this.parametersIndex = this.sqlParser.getParametersIndex();
    }

    protected void customizedBetweenWhereAndGroupBy() {
    }

    protected void customizedBetweenGroupByAndOrderBy() {
    }

    protected final void parseOrderBy() {
        if (!this.sqlParser.skipIfEqual(DefaultKeyword.ORDER)) {
            return;
        }
        LinkedList<OrderItem> result = new LinkedList<OrderItem>();
        this.sqlParser.skipIfEqual(DefaultKeyword.SIBLINGS);
        this.sqlParser.accept(DefaultKeyword.BY);
        do {
            OrderItem orderItem = this.parseSelectOrderByItem();
            if (this.isInSubQuery) continue;
            result.add(orderItem);
        } while (this.sqlParser.skipIfEqual(Symbol.COMMA));
        this.selectStatement.getOrderByItems().addAll(result);
    }

    private OrderItem parseSelectOrderByItem() {
        OrderItem result;
        SQLExpression sqlExpression = this.sqlParser.parseExpression(this.selectStatement);
        OrderType orderByType = OrderType.ASC;
        if (this.sqlParser.skipIfEqual(DefaultKeyword.ASC)) {
            orderByType = OrderType.ASC;
        } else if (this.sqlParser.skipIfEqual(DefaultKeyword.DESC)) {
            orderByType = OrderType.DESC;
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            result = new OrderItem(((SQLNumberExpression)sqlExpression).getNumber().intValue(), orderByType);
        } else if (sqlExpression instanceof SQLIdentifierExpression) {
            result = new OrderItem(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName())));
        } else if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            result = new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()) + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName())));
        } else if (sqlExpression instanceof SQLIgnoreExpression) {
            SQLIgnoreExpression sqlIgnoreExpression = (SQLIgnoreExpression)sqlExpression;
            result = new OrderItem(sqlIgnoreExpression.getExpression(), orderByType, this.getAlias(sqlIgnoreExpression.getExpression()));
        } else {
            throw new SQLParsingException(this.sqlParser.getLexer());
        }
        this.skipAfterOrderByItem();
        return result;
    }

    protected void skipAfterOrderByItem() {
    }

    protected void parseGroupBy() {
        if (this.sqlParser.skipIfEqual(DefaultKeyword.GROUP)) {
            this.sqlParser.accept(DefaultKeyword.BY);
            while (true) {
                this.addGroupByItem(this.sqlParser.parseExpression(this.selectStatement));
                if (!this.sqlParser.equalAny(Symbol.COMMA)) break;
                this.sqlParser.getLexer().nextToken();
            }
            while (this.sqlParser.equalAny(DefaultKeyword.WITH) || this.sqlParser.getLexer().getCurrentToken().getLiterals().equalsIgnoreCase("ROLLUP")) {
                this.sqlParser.getLexer().nextToken();
            }
            if (this.sqlParser.skipIfEqual(DefaultKeyword.HAVING)) {
                throw new UnsupportedOperationException("Cannot support Having");
            }
            this.selectStatement.setGroupByLastPosition(this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.getSqlParser().getLexer().getCurrentToken().getLiterals().length());
        } else if (this.sqlParser.skipIfEqual(DefaultKeyword.HAVING)) {
            throw new UnsupportedOperationException("Cannot support Having");
        }
    }

    protected final void addGroupByItem(SQLExpression sqlExpression) {
        OrderItem orderItem;
        OrderType orderByType = OrderType.ASC;
        if (this.sqlParser.equalAny(DefaultKeyword.ASC)) {
            this.sqlParser.getLexer().nextToken();
        } else if (this.sqlParser.skipIfEqual(DefaultKeyword.DESC)) {
            orderByType = OrderType.DESC;
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            orderItem = new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner() + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName()))));
        } else if (sqlExpression instanceof SQLIdentifierExpression) {
            SQLIdentifierExpression sqlIdentifierExpression = (SQLIdentifierExpression)sqlExpression;
            orderItem = new OrderItem(SQLUtil.getExactlyValue(sqlIdentifierExpression.getName()), orderByType, this.getAlias(SQLUtil.getExactlyValue(sqlIdentifierExpression.getName())));
        } else {
            return;
        }
        if (!this.isInSubQuery) {
            this.selectStatement.getGroupByItems().add(orderItem);
        }
    }

    private Optional<String> getAlias(String name) {
        if (this.selectStatement.isContainStar()) {
            return Optional.absent();
        }
        String rawName = SQLUtil.getExactlyValue(name);
        for (SelectItem each : this.selectStatement.getItems()) {
            if (rawName.equalsIgnoreCase(SQLUtil.getExactlyValue(each.getExpression()))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase((String)each.getAlias().orNull())) continue;
            return Optional.of((Object)rawName);
        }
        return Optional.absent();
    }

    private void parseFrom() {
        if (this.getSqlParser().equalAny(DefaultKeyword.INTO)) {
            throw new SQLParsingUnsupportedException(DefaultKeyword.INTO);
        }
        if (this.sqlParser.skipIfEqual(DefaultKeyword.FROM)) {
            this.parseTable();
        }
    }

    private void parseTable() {
        if (this.sqlParser.skipIfEqual(Symbol.LEFT_PAREN)) {
            if (!this.selectStatement.getTables().isEmpty()) {
                throw new UnsupportedOperationException("Cannot support subquery for nested tables.");
            }
            this.isInSubQuery = true;
            this.selectStatement.setContainStar(false);
            this.sqlParser.skipUselessParentheses();
            this.parse();
            this.sqlParser.skipUselessParentheses();
            if (this.getSqlParser().equalAny(DefaultKeyword.WHERE, Assist.END)) {
                return;
            }
        }
        this.isInSubQuery = false;
        this.customizedParseTableFactor();
        this.parseJoinTable();
    }

    protected void customizedParseTableFactor() {
        this.parseTableFactor();
    }

    protected final void parseTableFactor() {
        int beginPosition = this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length();
        this.sqlParser.skipAll(DefaultKeyword.AS);
        String literals = this.sqlParser.getLexer().getCurrentToken().getLiterals();
        this.sqlParser.getLexer().nextToken();
        if (this.sqlParser.skipIfEqual(Symbol.DOT)) {
            this.sqlParser.getLexer().nextToken();
            this.sqlParser.parseAlias();
            return;
        }
        this.selectStatement.getSqlTokens().add(new TableToken(beginPosition, literals));
        this.selectStatement.getTables().add(new Table(SQLUtil.getExactlyValue(literals), this.sqlParser.parseAlias()));
    }

    protected void parseJoinTable() {
        if (this.sqlParser.skipJoin()) {
            this.parseTable();
            if (this.sqlParser.skipIfEqual(DefaultKeyword.ON)) {
                do {
                    this.parseTableCondition(this.sqlParser.getLexer().getCurrentToken().getEndPosition());
                    this.sqlParser.accept(Symbol.EQ);
                    this.parseTableCondition(this.sqlParser.getLexer().getCurrentToken().getEndPosition() - this.sqlParser.getLexer().getCurrentToken().getLiterals().length());
                } while (this.sqlParser.skipIfEqual(DefaultKeyword.AND));
            } else if (this.sqlParser.skipIfEqual(DefaultKeyword.USING)) {
                this.sqlParser.skipParentheses();
            }
            this.parseJoinTable();
        }
    }

    private void parseTableCondition(int startPosition) {
        SQLExpression sqlExpression = this.sqlParser.parseExpression();
        if (!(sqlExpression instanceof SQLPropertyExpression)) {
            return;
        }
        SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
        if (this.selectStatement.getTables().getTableNames().contains(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()))) {
            this.selectStatement.getSqlTokens().add(new TableToken(startPosition, sqlPropertyExpression.getOwner().getName()));
        }
    }

    protected abstract void customizedSelect();

    private void processUnsupportedTokens() {
        if (this.sqlParser.equalAny(DefaultKeyword.UNION, DefaultKeyword.EXCEPT, DefaultKeyword.INTERSECT, DefaultKeyword.MINUS)) {
            throw new SQLParsingUnsupportedException(this.sqlParser.getLexer().getCurrentToken().getType());
        }
    }

    private void appendDerivedColumns() {
        if (this.appendDerivedColumnsFlag) {
            return;
        }
        this.appendDerivedColumnsFlag = true;
        ItemsToken itemsToken = new ItemsToken(this.selectStatement.getSelectListLastPosition());
        this.appendAvgDerivedColumns(itemsToken);
        this.appendDerivedOrderColumns(itemsToken, this.selectStatement.getOrderByItems(), ORDER_BY_DERIVED_ALIAS);
        this.appendDerivedOrderColumns(itemsToken, this.selectStatement.getGroupByItems(), GROUP_BY_DERIVED_ALIAS);
        if (!itemsToken.getItems().isEmpty()) {
            this.selectStatement.getSqlTokens().add(itemsToken);
        }
    }

    private void appendAvgDerivedColumns(ItemsToken itemsToken) {
        int derivedColumnOffset = 0;
        for (SelectItem each : this.selectStatement.getItems()) {
            if (!(each instanceof AggregationSelectItem) || AggregationType.AVG != ((AggregationSelectItem)each).getType()) continue;
            AggregationSelectItem avgItem = (AggregationSelectItem)each;
            String countAlias = String.format(DERIVED_COUNT_ALIAS, derivedColumnOffset);
            AggregationSelectItem countItem = new AggregationSelectItem(AggregationType.COUNT, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)countAlias));
            String sumAlias = String.format(DERIVED_SUM_ALIAS, derivedColumnOffset);
            AggregationSelectItem sumItem = new AggregationSelectItem(AggregationType.SUM, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)sumAlias));
            avgItem.getDerivedAggregationSelectItems().add(countItem);
            avgItem.getDerivedAggregationSelectItems().add(sumItem);
            itemsToken.getItems().add(countItem.getExpression() + " AS " + countAlias + " ");
            itemsToken.getItems().add(sumItem.getExpression() + " AS " + sumAlias + " ");
            ++derivedColumnOffset;
        }
    }

    private void appendDerivedOrderColumns(ItemsToken itemsToken, List<OrderItem> orderItems, String aliasPattern) {
        int derivedColumnOffset = 0;
        for (OrderItem each : orderItems) {
            if (this.isContainsItem(each)) continue;
            String alias = String.format(aliasPattern, derivedColumnOffset++);
            each.setAlias((Optional<String>)Optional.of((Object)alias));
            itemsToken.getItems().add((String)each.getQualifiedName().get() + " AS " + alias + " ");
        }
    }

    private boolean isContainsItem(OrderItem orderItem) {
        if (this.selectStatement.isContainStar()) {
            return true;
        }
        for (SelectItem each : this.selectStatement.getItems()) {
            if (-1 != orderItem.getIndex()) {
                return true;
            }
            if (each.getAlias().isPresent() && orderItem.getAlias().isPresent() && ((String)each.getAlias().get()).equalsIgnoreCase((String)orderItem.getAlias().get())) {
                return true;
            }
            if (each.getAlias().isPresent() || !orderItem.getQualifiedName().isPresent() || !each.getExpression().equalsIgnoreCase((String)orderItem.getQualifiedName().get())) continue;
            return true;
        }
        return false;
    }

    private void appendDerivedOrderBy() {
        if (!this.getSelectStatement().getGroupByItems().isEmpty() && this.getSelectStatement().getOrderByItems().isEmpty()) {
            this.getSelectStatement().getOrderByItems().addAll(this.getSelectStatement().getGroupByItems());
            this.getSelectStatement().getSqlTokens().add(new OrderByToken(this.getSelectStatement().getGroupByLastPosition()));
        }
    }

    protected AbstractSQLParser getSqlParser() {
        return this.sqlParser;
    }

    protected SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    protected int getParametersIndex() {
        return this.parametersIndex;
    }

    protected boolean isInSubQuery() {
        return this.isInSubQuery;
    }

    protected boolean isAppendDerivedColumnsFlag() {
        return this.appendDerivedColumnsFlag;
    }

    public void setParametersIndex(int parametersIndex) {
        this.parametersIndex = parametersIndex;
    }

    public void setInSubQuery(boolean isInSubQuery) {
        this.isInSubQuery = isInSubQuery;
    }
}

