/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dql.select;

import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.OrderItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.AggregationSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.SelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dql.DQLStatement;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SelectStatement
extends DQLStatement {
    private boolean containStar;
    private int selectListLastPosition;
    private int groupByLastPosition;
    private final List<SelectItem> items = new LinkedList<SelectItem>();
    private final List<OrderItem> groupByItems = new LinkedList<OrderItem>();
    private final List<OrderItem> orderByItems = new LinkedList<OrderItem>();
    private Limit limit;

    public List<AggregationSelectItem> getAggregationSelectItems() {
        LinkedList<AggregationSelectItem> result = new LinkedList<AggregationSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof AggregationSelectItem)) continue;
            AggregationSelectItem aggregationSelectItem = (AggregationSelectItem)each;
            result.add(aggregationSelectItem);
            for (AggregationSelectItem derivedEach : aggregationSelectItem.getDerivedAggregationSelectItems()) {
                result.add(derivedEach);
            }
        }
        return result;
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.getGroupByItems().isEmpty() && this.getGroupByItems().equals(this.getOrderByItems());
    }

    public void setIndexForItems(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationItem(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByItems);
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByItems);
    }

    private void setIndexForAggregationItem(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationSelectItem each : this.getAggregationSelectItems()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (Object)String.format("Can't find index: %s, please add alias for aggregate selections", each));
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationSelectItem derived : each.getDerivedAggregationSelectItems()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (Object)String.format("Can't find index: %s", derived));
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, List<OrderItem> orderItems) {
        for (OrderItem each : orderItems) {
            if (-1 != each.getIndex()) continue;
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (Object)String.format("Can't find index: %s", each));
            if (!columnLabelIndexMap.containsKey(each.getColumnLabel())) continue;
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
        }
    }

    public boolean isContainStar() {
        return this.containStar;
    }

    public int getSelectListLastPosition() {
        return this.selectListLastPosition;
    }

    public int getGroupByLastPosition() {
        return this.groupByLastPosition;
    }

    public List<SelectItem> getItems() {
        return this.items;
    }

    public List<OrderItem> getGroupByItems() {
        return this.groupByItems;
    }

    public List<OrderItem> getOrderByItems() {
        return this.orderByItems;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setContainStar(boolean containStar) {
        this.containStar = containStar;
    }

    public void setSelectListLastPosition(int selectListLastPosition) {
        this.selectListLastPosition = selectListLastPosition;
    }

    public void setGroupByLastPosition(int groupByLastPosition) {
        this.groupByLastPosition = groupByLastPosition;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    @Override
    public String toString() {
        return "SelectStatement(super=" + super.toString() + ", containStar=" + this.isContainStar() + ", selectListLastPosition=" + this.getSelectListLastPosition() + ", groupByLastPosition=" + this.getGroupByLastPosition() + ", items=" + this.getItems() + ", groupByItems=" + this.getGroupByItems() + ", orderByItems=" + this.getOrderByItems() + ", limit=" + this.getLimit() + ")";
    }
}

