/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.adapter;

import com.dangdang.ddframe.rdb.sharding.jdbc.unsupported.AbstractUnsupportedOperationConnection;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractConnectionAdapter
extends AbstractUnsupportedOperationConnection {
    private boolean autoCommit = true;
    private boolean readOnly = true;
    private boolean closed;
    private int transactionIsolation = 1;

    protected abstract Collection<Connection> getConnections();

    @Override
    public final boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.getConnections().isEmpty()) {
            this.recordMethodInvocation(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{autoCommit});
            return;
        }
        for (Connection each : this.getConnections()) {
            each.setAutoCommit(autoCommit);
        }
    }

    @Override
    public final void commit() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : this.getConnections()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final void rollback() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : this.getConnections()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        MetricsContext.clear();
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : this.getConnections()) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        if (this.getConnections().isEmpty()) {
            this.recordMethodInvocation(Connection.class, "setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{readOnly});
            return;
        }
        for (Connection each : this.getConnections()) {
            each.setReadOnly(readOnly);
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
        if (this.getConnections().isEmpty()) {
            this.recordMethodInvocation(Connection.class, "setTransactionIsolation", new Class[]{Integer.TYPE}, new Object[]{level});
            return;
        }
        for (Connection each : this.getConnections()) {
            each.setTransactionIsolation(level);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public final int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public final void setHoldability(int holdability) throws SQLException {
    }
}

