/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.connection;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractConnectionAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.ShardingContext;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource.MasterSlaveDataSource;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.statement.ShardingPreparedStatement;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.statement.ShardingStatement;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final ShardingContext shardingContext;
    private final Map<String, Connection> connectionMap = new HashMap<String, Connection>();

    public Collection<Connection> getConnectionForDDL(String dataSourceName) throws SQLException {
        Timer.Context metricsContext = MetricsContext.start(Joiner.on((String)"-").join((Object)"ShardingConnection-getConnectionForDDL", (Object)dataSourceName, new Object[0]));
        DataSource dataSource = this.shardingContext.getShardingRule().getDataSourceRule().getDataSource(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the rule of %s in DataSourceRule", (Object[])new Object[]{dataSourceName});
        LinkedList<DataSource> dataSources = new LinkedList<DataSource>();
        if (dataSource instanceof MasterSlaveDataSource) {
            dataSources.add(((MasterSlaveDataSource)dataSource).getMasterDataSource());
            dataSources.addAll(((MasterSlaveDataSource)dataSource).getSlaveDataSources());
        } else {
            dataSources.add(dataSource);
        }
        LinkedList<Connection> result = new LinkedList<Connection>();
        for (DataSource each : dataSources) {
            Connection connection = each.getConnection();
            this.replayMethodsInvocation(connection);
            result.add(connection);
        }
        MetricsContext.stop(metricsContext);
        return result;
    }

    public Connection getConnection(String dataSourceName, SQLType sqlType) throws SQLException {
        String realDataSourceName;
        Optional<Connection> connection = this.getCachedConnection(dataSourceName, sqlType);
        if (connection.isPresent()) {
            return (Connection)connection.get();
        }
        Timer.Context metricsContext = MetricsContext.start(Joiner.on((String)"-").join((Object)"ShardingConnection-getConnection", (Object)dataSourceName, new Object[0]));
        DataSource dataSource = this.shardingContext.getShardingRule().getDataSourceRule().getDataSource(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the rule of %s in DataSourceRule", (Object[])new Object[]{dataSourceName});
        if (dataSource instanceof MasterSlaveDataSource) {
            dataSource = ((MasterSlaveDataSource)dataSource).getDataSource(sqlType);
            realDataSourceName = MasterSlaveDataSource.getDataSourceName(dataSourceName, sqlType);
        } else {
            realDataSourceName = dataSourceName;
        }
        Connection result = dataSource.getConnection();
        MetricsContext.stop(metricsContext);
        this.connectionMap.put(realDataSourceName, result);
        this.replayMethodsInvocation(result);
        return result;
    }

    private Optional<Connection> getCachedConnection(String dataSourceName, SQLType sqlType) {
        String key = this.connectionMap.containsKey(dataSourceName) ? dataSourceName : MasterSlaveDataSource.getDataSourceName(dataSourceName, sqlType);
        return Optional.fromNullable((Object)this.connectionMap.get(key));
    }

    public void release(Connection connection) {
        this.connectionMap.values().remove(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection(this.shardingContext.getShardingRule().getDataSourceRule().getDataSourceNames().iterator().next(), SQLType.DQL).getMetaData();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ShardingPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ShardingStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Collection<Connection> getConnections() {
        return this.connectionMap.values();
    }

    @Override
    public void close() throws SQLException {
        HintManagerHolder.clear();
        MasterSlaveDataSource.resetDMLFlag();
        super.close();
    }

    @ConstructorProperties(value={"shardingContext"})
    public ShardingConnection(ShardingContext shardingContext) {
        this.shardingContext = shardingContext;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

