/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.statement;

import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.executor.type.batch.BatchPreparedStatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.type.batch.BatchPreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.type.prepared.PreparedStatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.type.prepared.PreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractPreparedStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset.ShardingResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.MergeEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GeneratedKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.routing.PreparedStatementRoutingEngine;
import com.dangdang.ddframe.rdb.sharding.routing.SQLExecutionUnit;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class ShardingPreparedStatement
extends AbstractPreparedStatementAdapter {
    private final PreparedStatementRoutingEngine routingEngine;
    private final List<BatchPreparedStatementUnit> batchStatementUnits = new LinkedList<BatchPreparedStatementUnit>();
    private final List<List<Object>> parameterSets = new LinkedList<List<Object>>();

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql) {
        this(shardingConnection, sql, 1003, 1007, 1);
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency) {
        this(shardingConnection, sql, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int autoGeneratedKeys) {
        this(shardingConnection, sql);
        if (1 == autoGeneratedKeys) {
            this.markReturnGeneratedKeys();
        }
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(shardingConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.routingEngine = new PreparedStatementRoutingEngine(sql, shardingConnection.getShardingContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingResultSet result;
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            List<ResultSet> resultSets = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.getRouteResult().getSqlStatement().getType(), preparedStatementUnits, this.getParameters()).executeQuery();
            result = new ShardingResultSet(resultSets, new MergeEngine(resultSets, (SelectStatement)this.getRouteResult().getSqlStatement()).merge());
        }
        finally {
            this.clearBatch();
        }
        this.setCurrentResultSet(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            int n = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.getRouteResult().getSqlStatement().getType(), preparedStatementUnits, this.getParameters()).executeUpdate();
            return n;
        }
        finally {
            this.clearBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            boolean bl = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.getRouteResult().getSqlStatement().getType(), preparedStatementUnits, this.getParameters()).execute();
            return bl;
        }
        finally {
            this.clearBatch();
        }
    }

    private Collection<PreparedStatementUnit> route() throws SQLException {
        LinkedList<PreparedStatementUnit> result = new LinkedList<PreparedStatementUnit>();
        this.setRouteResult(this.routingEngine.route(this.getParameters()));
        for (SQLExecutionUnit each : this.getRouteResult().getExecutionUnits()) {
            SQLType sqlType = this.getRouteResult().getSqlStatement().getType();
            Collection<PreparedStatement> preparedStatements = SQLType.DDL == sqlType ? this.generatePreparedStatementForDDL(each) : Collections.singletonList(this.generatePreparedStatement(each));
            this.getRoutedStatements().addAll(preparedStatements);
            for (PreparedStatement preparedStatement : preparedStatements) {
                this.replaySetParameter(preparedStatement);
                result.add(new PreparedStatementUnit(each, preparedStatement));
            }
        }
        return result;
    }

    private Collection<PreparedStatement> generatePreparedStatementForDDL(SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        LinkedList<PreparedStatement> result = new LinkedList<PreparedStatement>();
        Collection<Connection> connections = this.getShardingConnection().getConnectionForDDL(sqlExecutionUnit.getDataSource());
        for (Connection each : connections) {
            result.add(each.prepareStatement(sqlExecutionUnit.getSql(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability()));
        }
        return result;
    }

    private PreparedStatement generatePreparedStatement(SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        Connection connection = this.getShardingConnection().getConnection(sqlExecutionUnit.getDataSource(), this.getRouteResult().getSqlStatement().getType());
        if (this.isReturnGeneratedKeys() || this.isReturnGeneratedKeys() && generatedKey.isPresent()) {
            return connection.prepareStatement(sqlExecutionUnit.getSql(), 1);
        }
        return connection.prepareStatement(sqlExecutionUnit.getSql(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
    }

    @Override
    public void clearBatch() throws SQLException {
        this.setCurrentResultSet(null);
        this.clearParameters();
        this.batchStatementUnits.clear();
        this.parameterSets.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            for (BatchPreparedStatementUnit each : this.routeBatch()) {
                each.getStatement().addBatch();
                each.mapAddBatchCount(this.parameterSets.size());
            }
            this.parameterSets.add(this.getParameters());
        }
        finally {
            this.setCurrentResultSet(null);
            this.clearParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = new BatchPreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.getShardingConnection().getShardingContext().getDatabaseType(), this.getRouteResult().getSqlStatement().getType(), this.batchStatementUnits, this.parameterSets).executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private List<BatchPreparedStatementUnit> routeBatch() throws SQLException {
        ArrayList<BatchPreparedStatementUnit> result = new ArrayList<BatchPreparedStatementUnit>();
        this.setRouteResult(this.routingEngine.route(this.getParameters()));
        for (SQLExecutionUnit each : this.getRouteResult().getExecutionUnits()) {
            BatchPreparedStatementUnit batchStatementUnit = this.getPreparedBatchStatement(each);
            this.replaySetParameter(batchStatementUnit.getStatement());
            result.add(batchStatementUnit);
        }
        return result;
    }

    private BatchPreparedStatementUnit getPreparedBatchStatement(final SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        Optional preparedBatchStatement = Iterators.tryFind(this.batchStatementUnits.iterator(), (Predicate)new Predicate<BatchPreparedStatementUnit>(){

            public boolean apply(BatchPreparedStatementUnit input) {
                return Objects.equals(input.getSqlExecutionUnit(), sqlExecutionUnit);
            }
        });
        if (preparedBatchStatement.isPresent()) {
            return (BatchPreparedStatementUnit)preparedBatchStatement.get();
        }
        BatchPreparedStatementUnit result = new BatchPreparedStatementUnit(sqlExecutionUnit, this.generatePreparedStatement(sqlExecutionUnit));
        this.batchStatementUnits.add(result);
        return result;
    }
}

