/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.config.ShardingProperties;
import com.dangdang.ddframe.rdb.sharding.config.ShardingPropertiesConstant;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public final class MetricsContext {
    private static final ThreadLocal<MetricRegistry> HOLDER = new ThreadLocal();
    private static final String LOGGER_NAME = "Sharding-JDBC-Metrics";

    public static void init(ShardingProperties shardingProperties) {
        HOLDER.remove();
        boolean metricsEnabled = (Boolean)shardingProperties.getValue(ShardingPropertiesConstant.METRICS_ENABLE);
        if (!metricsEnabled) {
            return;
        }
        long period = (Long)shardingProperties.getValue(ShardingPropertiesConstant.METRICS_MILLISECONDS_PERIOD);
        MetricRegistry metricRegistry = new MetricRegistry();
        Slf4jReporter.forRegistry((MetricRegistry)metricRegistry).outputTo(LoggerFactory.getLogger((String)LOGGER_NAME)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).withLoggingLevel(Slf4jReporter.LoggingLevel.DEBUG).build().start(period, TimeUnit.MILLISECONDS);
        HOLDER.set(metricRegistry);
    }

    public static Timer.Context start(String name) {
        return null == HOLDER.get() ? null : HOLDER.get().timer(MetricRegistry.name((String)name, (String[])new String[0])).time();
    }

    public static void stop(Timer.Context context) {
        if (null != context) {
            context.stop();
        }
    }

    public static void clear() {
        HOLDER.remove();
    }

    private MetricsContext() {
    }
}

