/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.clause;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.AliasClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.ExpressionClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.LimitValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.SelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table.Table;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.table.Tables;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIdentifierExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPropertyExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLTextExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountToken;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import java.util.LinkedList;
import java.util.List;

public class WhereClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final AliasClauseParser aliasClauseParser;
    private final ExpressionClauseParser expressionClauseParser;

    public WhereClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.aliasClauseParser = new AliasClauseParser(lexerEngine);
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public void parse(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        this.aliasClauseParser.parse();
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.WHERE)) {
            this.parseConditions(shardingRule, sqlStatement, items);
        }
    }

    private void parseConditions(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        do {
            this.parseComparisonCondition(shardingRule, sqlStatement, items);
        } while (this.lexerEngine.skipIfEqual(DefaultKeyword.AND));
        this.lexerEngine.unsupportedIfEqual(DefaultKeyword.OR);
    }

    private void parseComparisonCondition(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN);
        SQLExpression left = this.expressionClauseParser.parse(sqlStatement);
        if (this.lexerEngine.equalAny(Symbol.EQ)) {
            this.parseEqualCondition(shardingRule, sqlStatement, left);
            this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
            return;
        }
        if (this.lexerEngine.equalAny(DefaultKeyword.IN)) {
            this.parseInCondition(shardingRule, sqlStatement, left);
            this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
            return;
        }
        if (this.lexerEngine.equalAny(DefaultKeyword.BETWEEN)) {
            this.parseBetweenCondition(shardingRule, sqlStatement, left);
            this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
            return;
        }
        if (this.lexerEngine.equalAny(Symbol.LT, Symbol.GT, Symbol.LT_EQ, Symbol.GT_EQ)) {
            if (left instanceof SQLIdentifierExpression && sqlStatement instanceof SelectStatement && this.isRowNumberCondition(items, ((SQLIdentifierExpression)left).getName())) {
                this.parseRowNumberCondition((SelectStatement)sqlStatement);
            } else if (left instanceof SQLPropertyExpression && sqlStatement instanceof SelectStatement && this.isRowNumberCondition(items, ((SQLPropertyExpression)left).getName())) {
                this.parseRowNumberCondition((SelectStatement)sqlStatement);
            } else {
                this.parseOtherCondition(sqlStatement);
            }
        } else if (this.lexerEngine.equalAny(Symbol.LT_GT, DefaultKeyword.LIKE)) {
            this.parseOtherCondition(sqlStatement);
        }
        this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
    }

    private void parseEqualCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        Optional<Column> column;
        this.lexerEngine.nextToken();
        SQLExpression right = this.expressionClauseParser.parse(sqlStatement);
        if ((sqlStatement.getTables().isSingleTable() || left instanceof SQLPropertyExpression) && (right instanceof SQLNumberExpression || right instanceof SQLTextExpression || right instanceof SQLPlaceholderExpression) && (column = this.find(sqlStatement.getTables(), left)).isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), right), shardingRule);
        }
    }

    private void parseInCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        this.lexerEngine.nextToken();
        this.lexerEngine.accept(Symbol.LEFT_PAREN);
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        do {
            if (this.lexerEngine.equalAny(Symbol.COMMA)) {
                this.lexerEngine.nextToken();
            }
            rights.add(this.expressionClauseParser.parse(sqlStatement));
        } while (!this.lexerEngine.equalAny(Symbol.RIGHT_PAREN));
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), rights), shardingRule);
        }
        this.lexerEngine.nextToken();
    }

    private void parseBetweenCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        this.lexerEngine.nextToken();
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        rights.add(this.expressionClauseParser.parse(sqlStatement));
        this.lexerEngine.accept(DefaultKeyword.AND);
        rights.add(this.expressionClauseParser.parse(sqlStatement));
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent()) {
            sqlStatement.getConditions().add(new Condition((Column)column.get(), (SQLExpression)rights.get(0), (SQLExpression)rights.get(1)), shardingRule);
        }
    }

    protected boolean isRowNumberCondition(List<SelectItem> items, String columnLabel) {
        return false;
    }

    private void parseRowNumberCondition(SelectStatement selectStatement) {
        Symbol symbol = (Symbol)this.lexerEngine.getCurrentToken().getType();
        this.lexerEngine.nextToken();
        SQLExpression sqlExpression = this.expressionClauseParser.parse(selectStatement);
        if (null == selectStatement.getLimit()) {
            selectStatement.setLimit(new Limit(false));
        }
        if (Symbol.LT == symbol || Symbol.LT_EQ == symbol) {
            if (sqlExpression instanceof SQLNumberExpression) {
                int rowCount = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
                selectStatement.getLimit().setRowCount(new LimitValue(rowCount, -1));
                selectStatement.getSqlTokens().add(new RowCountToken(this.lexerEngine.getCurrentToken().getEndPosition() - String.valueOf(rowCount).length() - this.lexerEngine.getCurrentToken().getLiterals().length(), rowCount));
            } else if (sqlExpression instanceof SQLPlaceholderExpression) {
                selectStatement.getLimit().setRowCount(new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex()));
            }
        } else if (Symbol.GT == symbol || Symbol.GT_EQ == symbol) {
            if (sqlExpression instanceof SQLNumberExpression) {
                int offset = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
                selectStatement.getLimit().setOffset(new LimitValue(offset, -1));
                selectStatement.getSqlTokens().add(new OffsetToken(this.lexerEngine.getCurrentToken().getEndPosition() - String.valueOf(offset).length() - this.lexerEngine.getCurrentToken().getLiterals().length(), offset));
            } else if (sqlExpression instanceof SQLPlaceholderExpression) {
                selectStatement.getLimit().setOffset(new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex()));
            }
        }
    }

    private void parseOtherCondition(SQLStatement sqlStatement) {
        this.lexerEngine.nextToken();
        this.expressionClauseParser.parse(sqlStatement);
    }

    private Optional<Column> find(Tables tables, SQLExpression sqlExpression) {
        if (sqlExpression instanceof SQLPropertyExpression) {
            return this.getColumnWithOwner(tables, (SQLPropertyExpression)sqlExpression);
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            return this.getColumnWithoutOwner(tables, (SQLIdentifierExpression)sqlExpression);
        }
        return Optional.absent();
    }

    private Optional<Column> getColumnWithOwner(Tables tables, SQLPropertyExpression propertyExpression) {
        Optional<Table> table = tables.find(SQLUtil.getExactlyValue(propertyExpression.getOwner().getName()));
        return propertyExpression.getOwner() instanceof SQLIdentifierExpression && table.isPresent() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(propertyExpression.getName()), ((Table)table.get()).getName())) : Optional.absent();
    }

    private Optional<Column> getColumnWithoutOwner(Tables tables, SQLIdentifierExpression identifierExpression) {
        return tables.isSingleTable() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(identifierExpression.getName()), tables.getSingleTableName())) : Optional.absent();
    }
}

