/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver.clause;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.sqlserver.SQLServerKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.LimitValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;
import java.beans.ConstructorProperties;

public final class SQLServerOffsetClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;

    public void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(SQLServerKeyword.OFFSET)) {
            return;
        }
        int offsetValue = -1;
        int offsetIndex = -1;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            offsetValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            offsetIndex = selectStatement.getParametersIndex();
            selectStatement.increaseParametersIndex();
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        Limit limit = new Limit(true);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FETCH)) {
            this.lexerEngine.nextToken();
            int rowCountValue = -1;
            int rowCountIndex = -1;
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Literals.INT)) {
                rowCountValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                rowCountIndex = selectStatement.getParametersIndex();
                selectStatement.increaseParametersIndex();
            } else {
                throw new SQLParsingException(this.lexerEngine);
            }
            this.lexerEngine.nextToken();
            this.lexerEngine.nextToken();
            limit.setRowCount(new LimitValue(rowCountValue, rowCountIndex));
            limit.setOffset(new LimitValue(offsetValue, offsetIndex));
        } else {
            limit.setOffset(new LimitValue(offsetValue, offsetIndex));
        }
        selectStatement.setLimit(limit);
    }

    @ConstructorProperties(value={"lexerEngine"})
    public SQLServerOffsetClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

