/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.routing.router;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.ShardingContext;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.dangdang.ddframe.rdb.sharding.parsing.SQLJudgeEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.routing.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.routing.SQLRouteResult;
import com.dangdang.ddframe.rdb.sharding.routing.router.SQLRouter;
import com.dangdang.ddframe.rdb.sharding.routing.type.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.routing.type.TableUnit;
import com.dangdang.ddframe.rdb.sharding.routing.type.hint.DatabaseHintRoutingEngine;
import com.dangdang.ddframe.rdb.sharding.util.SQLLogger;
import java.util.List;

public final class DatabaseHintSQLRouter
implements SQLRouter {
    private final ShardingRule shardingRule;
    private final boolean showSQL;

    public DatabaseHintSQLRouter(ShardingContext shardingContext) {
        this.shardingRule = shardingContext.getShardingRule();
        this.showSQL = shardingContext.isShowSQL();
    }

    @Override
    public SQLStatement parse(String logicSQL, int parametersSize) {
        return new SQLJudgeEngine(logicSQL).judge();
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        Timer.Context context = MetricsContext.start("Route SQL");
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        RoutingResult routingResult = new DatabaseHintRoutingEngine(this.shardingRule.getDataSourceRule(), this.shardingRule.getDatabaseShardingStrategy()).route();
        for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
            result.getExecutionUnits().add(new SQLExecutionUnit(each.getDataSourceName(), logicSQL));
        }
        MetricsContext.stop(context);
        if (this.showSQL) {
            SQLLogger.logSQL(logicSQL, sqlStatement, result.getExecutionUnits(), parameters);
        }
        return result;
    }
}

