/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.type.statement;

import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.executor.BaseStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteCallback;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.executor.type.statement.StatementUnit;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;

public final class StatementExecutor {
    private final ExecutorEngine executorEngine;
    private final SQLType sqlType;
    private final Collection<StatementUnit> statementUnits;

    public List<ResultSet> executeQuery() {
        return this.executorEngine.executeStatement(this.sqlType, this.statementUnits, new ExecuteCallback<ResultSet>(){

            @Override
            public ResultSet execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return baseStatementUnit.getStatement().executeQuery(baseStatementUnit.getSqlExecutionUnit().getSql());
            }
        });
    }

    public int executeUpdate() {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql);
            }
        });
    }

    public int executeUpdate(final int autoGeneratedKeys) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    public int executeUpdate(final int[] columnIndexes) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnIndexes);
            }
        });
    }

    public int executeUpdate(final String[] columnNames) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnNames);
            }
        });
    }

    private int executeUpdate(final Updater updater) {
        List<Integer> results = this.executorEngine.executeStatement(this.sqlType, this.statementUnits, new ExecuteCallback<Integer>(){

            @Override
            public Integer execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return updater.executeUpdate(baseStatementUnit.getStatement(), baseStatementUnit.getSqlExecutionUnit().getSql());
            }
        });
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql);
            }
        });
    }

    public boolean execute(final int autoGeneratedKeys) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, autoGeneratedKeys);
            }
        });
    }

    public boolean execute(final int[] columnIndexes) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnIndexes);
            }
        });
    }

    public boolean execute(final String[] columnNames) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnNames);
            }
        });
    }

    private boolean execute(final Executor executor) {
        List<Boolean> result = this.executorEngine.executeStatement(this.sqlType, this.statementUnits, new ExecuteCallback<Boolean>(){

            @Override
            public Boolean execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return executor.execute(baseStatementUnit.getStatement(), baseStatementUnit.getSqlExecutionUnit().getSql());
            }
        });
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    @ConstructorProperties(value={"executorEngine", "sqlType", "statementUnits"})
    public StatementExecutor(ExecutorEngine executorEngine, SQLType sqlType, Collection<StatementUnit> statementUnits) {
        this.executorEngine = executorEngine;
        this.sqlType = sqlType;
        this.statementUnits = statementUnits;
    }

    private static interface Executor {
        public boolean execute(Statement var1, String var2) throws SQLException;
    }

    private static interface Updater {
        public int executeUpdate(Statement var1, String var2) throws SQLException;
    }
}

