/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.statement;

import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.executor.type.statement.StatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.type.statement.StatementUnit;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset.GeneratedKeysResultSet;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset.ShardingResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.MergeEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GeneratedKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.routing.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.routing.SQLRouteResult;
import com.dangdang.ddframe.rdb.sharding.routing.StatementRoutingEngine;
import com.google.common.base.Optional;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection connection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Collection<Statement> routedStatements = new LinkedList<Statement>();
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingStatement(ShardingConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingResultSet result;
        try {
            List<ResultSet> resultSets = this.generateExecutor(sql).executeQuery();
            result = new ShardingResultSet(resultSets, new MergeEngine(resultSets, (SelectStatement)this.routeResult.getSqlStatement()).merge());
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            int n = this.generateExecutor(sql).executeUpdate();
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            int n = this.generateExecutor(sql).executeUpdate(autoGeneratedKeys);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnIndexes);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnNames);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            boolean bl = this.generateExecutor(sql).execute();
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            boolean bl = this.generateExecutor(sql).execute(autoGeneratedKeys);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            boolean bl = this.generateExecutor(sql).execute(columnIndexes);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            boolean bl = this.generateExecutor(sql).execute(columnNames);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private StatementExecutor generateExecutor(String sql) throws SQLException {
        this.clearPrevious();
        this.routeResult = new StatementRoutingEngine(this.connection.getShardingContext()).route(sql);
        LinkedList<StatementUnit> statementUnits = new LinkedList<StatementUnit>();
        for (SQLExecutionUnit each : this.routeResult.getExecutionUnits()) {
            SQLType sqlType = this.routeResult.getSqlStatement().getType();
            Collection<Connection> connections = SQLType.DDL == sqlType ? this.connection.getAllConnections(each.getDataSource()) : Collections.singletonList(this.connection.getConnection(each.getDataSource(), this.routeResult.getSqlStatement().getType()));
            for (Connection connection : connections) {
                Statement statement = connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
                this.replayMethodsInvocation(statement);
                statementUnits.add(new StatementUnit(each, statement));
                this.routedStatements.add(statement);
            }
        }
        return new StatementExecutor(this.connection.getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), statementUnits);
    }

    private void clearPrevious() throws SQLException {
        for (Statement each : this.routedStatements) {
            each.close();
        }
        this.routedStatements.clear();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn(), this);
        }
        if (1 == this.getRoutedStatements().size()) {
            return this.getRoutedStatements().iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)((InsertStatement)this.routeResult.getSqlStatement()).getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.routedStatements.size()) {
            this.currentResultSet = this.routedStatements.iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.routedStatements.size());
        for (Statement each : this.routedStatements) {
            resultSets.add(each.getResultSet());
        }
        this.currentResultSet = new ShardingResultSet(resultSets, new MergeEngine(resultSets, (SelectStatement)this.routeResult.getSqlStatement()).merge());
        return this.currentResultSet;
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.routedStatements;
    }
}

