/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.lexer;

import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLLexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.oracle.OracleLexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.postgresql.PostgreSQLLexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.sqlserver.SQLServerLexer;

public final class LexerEngineFactory {
    public static LexerEngine newInstance(DatabaseType dbType, String sql) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new LexerEngine(new MySQLLexer(sql));
            }
            case Oracle: {
                return new LexerEngine(new OracleLexer(sql));
            }
            case SQLServer: {
                return new LexerEngine(new SQLServerLexer(sql));
            }
            case PostgreSQL: {
                return new LexerEngine(new PostgreSQLLexer(sql));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private LexerEngineFactory() {
    }
}

