/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngineFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLStatement;
import java.beans.ConstructorProperties;

public final class SQLParsingEngine {
    private final DatabaseType dbType;
    private final String sql;
    private final ShardingRule shardingRule;

    public SQLStatement parse() {
        LexerEngine lexerEngine = LexerEngineFactory.newInstance(this.dbType, this.sql);
        lexerEngine.nextToken();
        return SQLParserFactory.newInstance(this.dbType, lexerEngine.getCurrentToken().getType(), this.shardingRule, lexerEngine).parse();
    }

    @ConstructorProperties(value={"dbType", "sql", "shardingRule"})
    public SQLParsingEngine(DatabaseType dbType, String sql, ShardingRule shardingRule) {
        this.dbType = dbType;
        this.sql = sql;
        this.shardingRule = shardingRule;
    }
}

