/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.clause;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.TableReferencesClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertStatement;
import java.beans.ConstructorProperties;

public class InsertIntoClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public void parse(InsertStatement insertStatement) {
        this.lexerEngine.unsupportedIfEqual(this.getUnsupportedKeywordsBeforeInto());
        this.lexerEngine.skipUntil(DefaultKeyword.INTO);
        this.lexerEngine.nextToken();
        this.tableReferencesClauseParser.parse(insertStatement, true);
        this.skipBetweenTableAndValues(insertStatement);
    }

    protected Keyword[] getUnsupportedKeywordsBeforeInto() {
        return new Keyword[0];
    }

    private void skipBetweenTableAndValues(InsertStatement insertStatement) {
        while (this.lexerEngine.skipIfEqual(this.getSkippedKeywordsBetweenTableAndValues())) {
            this.lexerEngine.nextToken();
            if (!this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) continue;
            this.lexerEngine.skipParentheses(insertStatement);
        }
    }

    protected Keyword[] getSkippedKeywordsBetweenTableAndValues() {
        return new Keyword[0];
    }

    @ConstructorProperties(value={"lexerEngine", "tableReferencesClauseParser"})
    public InsertIntoClauseParser(LexerEngine lexerEngine, TableReferencesClauseParser tableReferencesClauseParser) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = tableReferencesClauseParser;
    }
}

