/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.clause;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.LimitValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountToken;
import java.beans.ConstructorProperties;

public final class MySQLLimitClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;

    public void parse(SelectStatement selectStatement) {
        int value;
        if (!this.lexerEngine.skipIfEqual(MySQLKeyword.LIMIT)) {
            return;
        }
        int valueIndex = -1;
        int valueBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        boolean isParameterForValue = false;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            value = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            valueBeginPosition -= (value + "").length();
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            valueIndex = selectStatement.getParametersIndex();
            value = -1;
            --valueBeginPosition;
            isParameterForValue = true;
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.COMMA)) {
            selectStatement.setLimit(this.getLimitWithComma(valueIndex, valueBeginPosition, value, isParameterForValue, selectStatement));
            return;
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.OFFSET)) {
            selectStatement.setLimit(this.getLimitWithOffset(valueIndex, valueBeginPosition, value, isParameterForValue, selectStatement));
            return;
        }
        if (!isParameterForValue) {
            selectStatement.getSqlTokens().add(new RowCountToken(valueBeginPosition, value));
        }
        Limit limit = new Limit(true);
        limit.setRowCount(new LimitValue(value, valueIndex));
        selectStatement.setLimit(limit);
    }

    private Limit getLimitWithComma(int index, int valueBeginPosition, int value, boolean isParameterForValue, SelectStatement selectStatement) {
        int rowCountValue;
        int rowCountBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        int rowCountIndex = -1;
        boolean isParameterForRowCount = false;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            rowCountValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            rowCountBeginPosition -= (rowCountValue + "").length();
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            rowCountIndex = -1 == index ? selectStatement.getParametersIndex() : index + 1;
            rowCountValue = -1;
            --rowCountBeginPosition;
            isParameterForRowCount = true;
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        if (!isParameterForValue) {
            selectStatement.getSqlTokens().add(new OffsetToken(valueBeginPosition, value));
        }
        if (!isParameterForRowCount) {
            selectStatement.getSqlTokens().add(new RowCountToken(rowCountBeginPosition, rowCountValue));
        }
        Limit result = new Limit(true);
        result.setRowCount(new LimitValue(rowCountValue, rowCountIndex));
        result.setOffset(new LimitValue(value, index));
        return result;
    }

    private Limit getLimitWithOffset(int index, int valueBeginPosition, int value, boolean isParameterForValue, SelectStatement selectStatement) {
        int offsetBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        int offsetValue = -1;
        int offsetIndex = -1;
        boolean isParameterForOffset = false;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            offsetValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            offsetBeginPosition -= (offsetValue + "").length();
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            offsetIndex = -1 == index ? selectStatement.getParametersIndex() : index + 1;
            --offsetBeginPosition;
            isParameterForOffset = true;
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        if (!isParameterForOffset) {
            selectStatement.getSqlTokens().add(new OffsetToken(offsetBeginPosition, offsetValue));
        }
        if (!isParameterForValue) {
            selectStatement.getSqlTokens().add(new RowCountToken(valueBeginPosition, value));
        }
        Limit result = new Limit(true);
        result.setRowCount(new LimitValue(value, index));
        result.setOffset(new LimitValue(offsetValue, offsetIndex));
        return result;
    }

    @ConstructorProperties(value={"lexerEngine"})
    public MySQLLimitClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

