/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.type.batch;

import com.dangdang.ddframe.rdb.sharding.executor.BaseStatementUnit;
import com.dangdang.ddframe.rdb.sharding.routing.SQLExecutionUnit;
import java.beans.ConstructorProperties;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;

public final class BatchPreparedStatementUnit
implements BaseStatementUnit {
    private final SQLExecutionUnit sqlExecutionUnit;
    private final PreparedStatement statement;
    private final Map<Integer, Integer> jdbcAndActualAddBatchCallTimesMap = new HashMap<Integer, Integer>();
    private int actualCallAddBatchTimes;

    public void mapAddBatchCount(int jdbcAddBatchTimes) {
        this.jdbcAndActualAddBatchCallTimesMap.put(jdbcAddBatchTimes, this.actualCallAddBatchTimes++);
    }

    @ConstructorProperties(value={"sqlExecutionUnit", "statement"})
    public BatchPreparedStatementUnit(SQLExecutionUnit sqlExecutionUnit, PreparedStatement statement) {
        this.sqlExecutionUnit = sqlExecutionUnit;
        this.statement = statement;
    }

    @Override
    public SQLExecutionUnit getSqlExecutionUnit() {
        return this.sqlExecutionUnit;
    }

    @Override
    public PreparedStatement getStatement() {
        return this.statement;
    }

    public Map<Integer, Integer> getJdbcAndActualAddBatchCallTimesMap() {
        return this.jdbcAndActualAddBatchCallTimesMap;
    }
}

