/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.clause;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.LinkedList;

public final class InsertColumnsClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;

    public void parse(InsertStatement insertStatement) {
        LinkedList<Column> result = new LinkedList<Column>();
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            String tableName = insertStatement.getTables().getSingleTableName();
            Optional<String> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
            int count = 0;
            do {
                this.lexerEngine.nextToken();
                String columnName = SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals());
                result.add(new Column(columnName, tableName));
                this.lexerEngine.nextToken();
                if (generateKeyColumn.isPresent() && ((String)generateKeyColumn.get()).equalsIgnoreCase(columnName)) {
                    insertStatement.setGenerateKeyColumnIndex(count);
                }
                ++count;
            } while (!this.lexerEngine.equalAny(Symbol.RIGHT_PAREN) && !this.lexerEngine.equalAny(Assist.END));
            insertStatement.setColumnsListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
            this.lexerEngine.nextToken();
        }
        insertStatement.getColumns().addAll(result);
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine"})
    public InsertColumnsClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
    }
}

