/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.clause;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLIgnoreExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLTextExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import java.beans.ConstructorProperties;

public class InsertSetClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;

    public void parse(InsertStatement insertStatement) {
        if (!this.lexerEngine.skipIfEqual(this.getCustomizedInsertKeywords())) {
            return;
        }
        do {
            SQLExpression sqlExpression;
            Column column = new Column(SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals()), insertStatement.getTables().getSingleTableName());
            this.lexerEngine.nextToken();
            this.lexerEngine.accept(Symbol.EQ);
            if (this.lexerEngine.equalAny(Literals.INT)) {
                sqlExpression = new SQLNumberExpression(Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals()));
            } else if (this.lexerEngine.equalAny(Literals.FLOAT)) {
                sqlExpression = new SQLNumberExpression(Double.parseDouble(this.lexerEngine.getCurrentToken().getLiterals()));
            } else if (this.lexerEngine.equalAny(Literals.CHARS)) {
                sqlExpression = new SQLTextExpression(this.lexerEngine.getCurrentToken().getLiterals());
            } else if (this.lexerEngine.equalAny(DefaultKeyword.NULL)) {
                sqlExpression = new SQLIgnoreExpression(DefaultKeyword.NULL.name());
            } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                sqlExpression = new SQLPlaceholderExpression(insertStatement.getParametersIndex());
                insertStatement.increaseParametersIndex();
            } else {
                throw new UnsupportedOperationException("");
            }
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Symbol.COMMA, DefaultKeyword.ON, Assist.END)) {
                insertStatement.getConditions().add(new Condition(column, sqlExpression), this.shardingRule);
                continue;
            }
            this.lexerEngine.skipUntil(Symbol.COMMA, DefaultKeyword.ON);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    protected Keyword[] getCustomizedInsertKeywords() {
        return new Keyword[0];
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine"})
    public InsertSetClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
    }
}

