/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.sql;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.TokenType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.alter.AlterParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.create.CreateParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.drop.DropParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.truncate.TruncateParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.delete.DeleteParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.update.UpdateParserFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectParserFactory;

public final class SQLParserFactory {
    public static SQLParser newInstance(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        if (!(tokenType instanceof DefaultKeyword)) {
            throw new SQLParsingUnsupportedException(tokenType);
        }
        switch ((DefaultKeyword)tokenType) {
            case SELECT: {
                return SelectParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case INSERT: {
                return InsertParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case UPDATE: {
                return UpdateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DELETE: {
                return DeleteParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case CREATE: {
                return CreateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case ALTER: {
                return AlterParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DROP: {
                return DropParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case TRUNCATE: {
                return TruncateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(lexerEngine.getCurrentToken().getType());
    }

    private SQLParserFactory() {
    }
}

