/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.drop;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.sql.MySQLDropParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.sql.OracleDropParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql.sql.PostgreSQLDropParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver.sql.SQLServerDropParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.drop.AbstractDropParser;

public final class DropParserFactory {
    public static AbstractDropParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLDropParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleDropParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerDropParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLDropParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private DropParserFactory() {
    }
}

