/*
 * Decompiled with CFR 0.152.
 */
package com.danidemi.jlubricant.springbatch;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.item.database.AbstractCursorItemReader;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.ExposedParsedSql;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class NamedJdbcCursorItemReader<T>
extends AbstractCursorItemReader<T> {
    PreparedStatement preparedStatement;
    PreparedStatementSetter preparedStatementSetter;
    String sql;
    RowMapper rowMapper;
    SqlParameterSource paramSource;
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private int cacheLimit = 256;
    private final Map<String, ExposedParsedSql> parsedSqlCache = new LinkedHashMap<String, ExposedParsedSql>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ExposedParsedSql> eldest) {
            return this.size() > NamedJdbcCursorItemReader.this.getCacheLimit();
        }
    };

    public void setParamSource(SqlParameterSource paramSource) {
        this.paramSource = paramSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExposedParsedSql getParsedSql(String sql) {
        if (this.getCacheLimit() <= 0) {
            return new ExposedParsedSql(NamedParameterUtils.parseSqlStatement((String)sql));
        }
        Map<String, ExposedParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            ExposedParsedSql parsedSql = this.parsedSqlCache.get(sql);
            if (parsedSql == null) {
                parsedSql = new ExposedParsedSql(NamedParameterUtils.parseSqlStatement((String)sql));
                this.parsedSqlCache.put(sql, parsedSql);
            }
            return parsedSql;
        }
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public NamedJdbcCursorItemReader() {
        this.setName(ClassUtils.getShortName(AbstractCursorItemReader.class));
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.sql, (String)"The SQL query must be provided");
        Assert.notNull((Object)this.rowMapper, (String)"RowMapper must be provided");
    }

    protected void openCursor(Connection con) {
        try {
            ParsedSql parsedSql1 = this.getParsedSql(this.sql).getDelegate();
            String sqlToUse1 = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql1, (SqlParameterSource)this.paramSource);
            Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql1, (SqlParameterSource)this.paramSource, null);
            List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql1, (SqlParameterSource)this.paramSource);
            PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse1, declaredParameters);
            pscf.setResultSetType(1003);
            pscf.setUpdatableResults(false);
            PreparedStatementCreator preparedStatementCreator = pscf.newPreparedStatementCreator(params);
            this.preparedStatement = preparedStatementCreator.createPreparedStatement(con);
            this.rs = this.preparedStatement.executeQuery();
            this.handleWarnings(this.preparedStatement);
        }
        catch (SQLException se) {
            this.close();
            throw this.getExceptionTranslator().translate("Executing query", this.getSql(), se);
        }
    }

    protected T readCursor(ResultSet rs, int currentRow) throws SQLException {
        return (T)this.rowMapper.mapRow(rs, currentRow);
    }

    protected void cleanupOnClose() throws Exception {
        JdbcUtils.closeStatement((Statement)this.preparedStatement);
    }

    public String getSql() {
        return this.sql;
    }
}

