/*
 * Decompiled with CFR 0.152.
 */
package com.danielfrak.code.springdoc.openapi.externalizeddocs;

import com.danielfrak.code.springdoc.openapi.externalizeddocs.ExternalizedSchema;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ExternalizedDocumentation
implements ModelConverter {
    private List<ExternalizedSchema> externalSchemas = new ArrayList<ExternalizedSchema>();

    public ExternalizedDocumentation(ApplicationContext ctx) {
        Map beans = ctx.getBeansWithAnnotation(ExternalizedSchema.class);
        for (String bean : beans.keySet()) {
            this.externalSchemas.add((ExternalizedSchema)ctx.findAnnotationOnBean(bean, ExternalizedSchema.class));
        }
    }

    public Schema<?> resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class typeClass = TypeFactory.rawClass((Type)type.getType());
        this.updateAnnotations(type, typeClass);
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    private void updateAnnotations(AnnotatedType type, Class<?> typeClass) {
        for (ExternalizedSchema externalSchema : this.externalSchemas) {
            if (externalSchema.source() != typeClass) continue;
            ArrayList<Annotation> annotations = type.getCtxAnnotations() != null ? new ArrayList<Annotation>(Arrays.asList(type.getCtxAnnotations())) : new ArrayList();
            annotations.add((Annotation)externalSchema.schema());
            type.setCtxAnnotations(annotations.toArray(new Annotation[0]));
        }
    }
}

