/*
 * Decompiled with CFR 0.152.
 */
package com.darylteo.gradle.javassist.tasks;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.build.IClassTransformer;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;

class TransformationAction
implements CopyAction {
    private File destinationDir;
    private IClassTransformer transformation;
    private List<File> sources = new LinkedList<File>();
    private Collection<File> classpath = new LinkedList<File>();

    public TransformationAction(File destinationDir, Collection<File> sources, Collection<File> classpath, IClassTransformer transformation) {
        this.destinationDir = destinationDir;
        this.sources.addAll(sources);
        this.classpath.addAll(classpath);
        this.transformation = transformation;
    }

    public WorkResult execute(CopyActionProcessingStream stream) {
        try {
            ClassPool pool = this.createPool();
            LoaderAction action = new LoaderAction(pool, this.destinationDir, this.transformation);
            stream.process((CopyActionProcessingStreamAction)action);
        }
        catch (Exception e) {
            throw new GradleException("Could not execute transformation", (Throwable)e);
        }
        return new SimpleWorkResult(true);
    }

    private ClassPool createPool() throws NotFoundException {
        ClassPool pool = new ClassPool(true);
        if (this.classpath != null) {
            for (File f : this.classpath) {
                pool.appendClassPath(f.toString());
            }
        }
        for (File f : this.sources) {
            pool.appendClassPath(f.toString());
        }
        return pool;
    }

    private class LoaderAction
    implements CopyActionProcessingStreamAction {
        private final ClassPool pool;
        private final String destinationDir;
        private IClassTransformer transformation;

        public LoaderAction(ClassPool pool, File destinationDir, IClassTransformer transformation) {
            this.pool = pool;
            this.destinationDir = destinationDir.toString();
            this.transformation = transformation;
        }

        public void processFile(FileCopyDetailsInternal details) {
            try {
                CtClass clazz;
                if (!details.isDirectory() && this.transformation.shouldTransform(clazz = this.loadClassFile(details.getFile()))) {
                    clazz.defrost();
                    this.transformation.applyTransformations(clazz);
                    clazz.writeFile(this.destinationDir);
                }
            }
            catch (Exception e) {
                throw new GradleException("An error occurred while trying to process class file ", (Throwable)e);
            }
        }

        private CtClass loadClassFile(File classFile) throws IOException {
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(classFile)));
            CtClass clazz = this.pool.makeClass((InputStream)stream);
            ((InputStream)stream).close();
            return clazz;
        }
    }
}

