/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.TimeToLiveSpecification;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import com.dasburo.spring.cache.dynamo.DynamoCacheWriter;
import com.dasburo.spring.cache.dynamo.rootattribute.RootAttribute;
import com.dasburo.spring.cache.dynamo.util.ByteUtils;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDynamoCacheWriter
implements DynamoCacheWriter {
    public static final String ATTRIBUTE_KEY = "key";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_TTL = "ttl";
    private final AmazonDynamoDB dynamoTemplate;
    private final Duration sleepTime;

    DefaultDynamoCacheWriter(AmazonDynamoDB dynamoTemplate) {
        this(dynamoTemplate, Duration.ZERO);
    }

    DefaultDynamoCacheWriter(AmazonDynamoDB dynamoTemplate, Duration sleepTime) {
        Assert.notNull((Object)dynamoTemplate, (String)"ConnectionFactory must not be null!");
        Assert.notNull((Object)sleepTime, (String)"SleepTime must not be null!");
        this.dynamoTemplate = dynamoTemplate;
        this.sleepTime = sleepTime;
    }

    @Override
    public AmazonDynamoDB getNativeCacheWriter() {
        return this.dynamoTemplate;
    }

    @Override
    public void put(String name, String key, byte[] value, @Nullable Duration ttl, @Nullable List<RootAttribute> rootAttributes) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.execute(name, connection -> {
            this.putInternal(name, key, value, ttl, rootAttributes);
            return "OK";
        });
    }

    @Override
    public byte[] get(String name, String key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.execute(name, connection -> this.getInternal(name, key));
    }

    @Override
    public byte[] putIfAbsent(String name, String key, @Nullable byte[] value, @Nullable Duration ttl, @Nullable List<RootAttribute> rootAttributes) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.execute(name, connection -> {
            if (this.isLockingCacheWriter()) {
                this.doLock(name);
            }
            try {
                byte[] byArray = this.getInternal(name, key);
                return byArray;
            }
            catch (NoSuchElementException e) {
                this.putInternal(name, key, value, ttl, rootAttributes);
            }
            finally {
                if (this.isLockingCacheWriter()) {
                    this.doUnlock(name);
                }
            }
            return null;
        });
    }

    @Override
    public void remove(String name, String key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.execute(name, connection -> {
            this.removeInternal(name, key);
            return "OK";
        });
    }

    @Override
    public void clear(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        this.execute(name, connection -> {
            try {
                if (this.isLockingCacheWriter()) {
                    this.doLock(name);
                }
                ScanRequest req = new ScanRequest(name);
                List items = this.dynamoTemplate.scan(req).getItems();
                items.parallelStream().forEach(map -> {
                    HashMap<String, AttributeValue> keyToDelete = new HashMap<String, AttributeValue>();
                    keyToDelete.put(ATTRIBUTE_KEY, (AttributeValue)map.get(ATTRIBUTE_KEY));
                    DeleteItemRequest delReq = new DeleteItemRequest(name, keyToDelete);
                    this.dynamoTemplate.deleteItem(delReq);
                });
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
            }
            finally {
                if (this.isLockingCacheWriter()) {
                    this.doUnlock(name);
                }
            }
            return "OK";
        });
    }

    @Override
    public boolean createIfNotExists(String name, Duration ttl, Long readCapacityUnits, Long writeCapacityUnits) {
        boolean created;
        block2: {
            Assert.notNull((Object)name, (String)"Name must not be null!");
            Assert.notNull((Object)ttl, (String)"TTL must not be null! Use Duration.ZERO to disable TTL.");
            created = false;
            try {
                this.dynamoTemplate.describeTable(name);
            }
            catch (ResourceNotFoundException e) {
                created = TableUtils.createTableIfNotExists((AmazonDynamoDB)this.dynamoTemplate, (CreateTableRequest)this.createTableRequest(name, readCapacityUnits, writeCapacityUnits));
                if (!created || ttl.isZero()) break block2;
                this.dynamoTemplate.updateTimeToLive(this.updateTimeToLiveRequest(name));
            }
        }
        return created;
    }

    private byte[] getInternal(String name, String key) {
        GetItemRequest request = new GetItemRequest().withAttributesToGet(new String[]{ATTRIBUTE_VALUE}).withTableName(name).withKey(Collections.singletonMap(ATTRIBUTE_KEY, new AttributeValue(key)));
        GetItemResult result = this.dynamoTemplate.getItem(request);
        if (result.getItem() != null) {
            return this.getAttributeValue(result);
        }
        throw new NoSuchElementException(String.format("No entry found for '%s'.", key));
    }

    private byte[] getAttributeValue(GetItemResult result) {
        AttributeValue attribute = (AttributeValue)result.getItem().get(ATTRIBUTE_VALUE);
        if (attribute == null) {
            throw new IllegalStateException(String.format("Attribute value does not match the expected '%s'.", ATTRIBUTE_VALUE));
        }
        ByteBuffer element = attribute.getB();
        if (element == null && attribute.getNULL().booleanValue()) {
            return null;
        }
        return ByteUtils.getBytes(element);
    }

    private void putInternal(String name, String key, @Nullable byte[] value, @Nullable Duration ttl, @Nullable List<RootAttribute> rootAttributes) {
        HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
        attributeValues.put(ATTRIBUTE_KEY, new AttributeValue().withS(key));
        if (value == null) {
            attributeValues.put(ATTRIBUTE_VALUE, new AttributeValue().withNULL(Boolean.valueOf(true)));
        } else {
            attributeValues.put(ATTRIBUTE_VALUE, new AttributeValue().withB(ByteBuffer.wrap(value)));
        }
        if (DefaultDynamoCacheWriter.shouldExpireWithin(ttl)) {
            attributeValues.put(ATTRIBUTE_TTL, new AttributeValue().withN(String.valueOf(Instant.now().plus(ttl).getEpochSecond())));
        }
        if (rootAttributes != null) {
            rootAttributes.forEach(rootAttribute -> attributeValues.put(rootAttribute.getName(), rootAttribute.getAttributeValue()));
        }
        PutItemRequest putItemRequest = new PutItemRequest().withTableName(name).withItem(attributeValues);
        this.dynamoTemplate.putItem(putItemRequest);
    }

    private void removeInternal(String name, String key) {
        this.dynamoTemplate.deleteItem(new DeleteItemRequest().withTableName(name).withKey(Collections.singletonMap(ATTRIBUTE_KEY, new AttributeValue(key))));
    }

    private void doLock(String name) {
        this.putInternal(name, DefaultDynamoCacheWriter.createCacheLockKey(name), "1".getBytes(), null, null);
    }

    private void doUnlock(String name) {
        try {
            this.removeInternal(name, DefaultDynamoCacheWriter.createCacheLockKey(name));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    private boolean doCheckLock(String name) {
        try {
            this.getInternal(name, DefaultDynamoCacheWriter.createCacheLockKey(name));
        }
        catch (ResourceNotFoundException | NoSuchElementException e) {
            return false;
        }
        return true;
    }

    private boolean isLockingCacheWriter() {
        return !this.sleepTime.isZero() && !this.sleepTime.isNegative();
    }

    private <T> T execute(String name, Function<AmazonDynamoDB, T> callback) {
        this.checkAndPotentiallyWaitUntilUnlocked(name);
        return callback.apply(this.dynamoTemplate);
    }

    private void checkAndPotentiallyWaitUntilUnlocked(String name) {
        if (!this.isLockingCacheWriter()) {
            return;
        }
        try {
            while (this.doCheckLock(name)) {
                Thread.sleep(this.sleepTime.toMillis());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PessimisticLockingFailureException(String.format("Interrupted while waiting to unlock cache %s", name), (Throwable)ex);
        }
    }

    private static boolean shouldExpireWithin(@Nullable Duration ttl) {
        return ttl != null && !ttl.isZero() && !ttl.isNegative();
    }

    private static String createCacheLockKey(String name) {
        return name + "~lock";
    }

    private CreateTableRequest createTableRequest(String name, Long readCapacityUnits, Long writeCapacityUnits) {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition().withAttributeName(ATTRIBUTE_KEY).withAttributeType(ScalarAttributeType.S));
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(new KeySchemaElement().withAttributeName(ATTRIBUTE_KEY).withKeyType(KeyType.HASH));
        return new CreateTableRequest().withTableName(name).withKeySchema(keySchema).withAttributeDefinitions(attributeDefinitions).withProvisionedThroughput(new ProvisionedThroughput(readCapacityUnits, writeCapacityUnits));
    }

    private UpdateTimeToLiveRequest updateTimeToLiveRequest(String name) {
        return new UpdateTimeToLiveRequest().withTableName(name).withTimeToLiveSpecification(new TimeToLiveSpecification().withEnabled(Boolean.valueOf(true)).withAttributeName(ATTRIBUTE_TTL));
    }
}

