/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo;

import com.dasburo.spring.cache.dynamo.DynamoCacheConfiguration;
import com.dasburo.spring.cache.dynamo.DynamoCacheWriter;
import com.dasburo.spring.cache.dynamo.rootattribute.RootAttribute;
import com.dasburo.spring.cache.dynamo.rootattribute.RootAttributeConfig;
import com.dasburo.spring.cache.dynamo.rootattribute.RootAttributeReader;
import com.dasburo.spring.cache.dynamo.serializer.DynamoSerializer;
import java.time.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class DynamoCache
implements Cache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoCache.class);
    private final String cacheName;
    private final DynamoCacheWriter writer;
    private final DynamoCacheConfiguration cacheConfig;
    private RootAttributeReader rootAttributeReader = new RootAttributeReader();

    public DynamoCache(String cacheName, DynamoCacheWriter writer) {
        this(cacheName, writer, DynamoCacheConfiguration.defaultCacheConfig());
    }

    public DynamoCache(String cacheName, DynamoCacheWriter writer, DynamoCacheConfiguration cacheConfig) {
        Assert.hasText((String)cacheName, (String)"'cacheName' must be not null and not empty.");
        Assert.notNull((Object)writer, (String)"'writer' must not be null.");
        this.cacheName = cacheName;
        this.writer = writer;
        this.cacheConfig = cacheConfig;
        this.initialize();
    }

    public void clear() {
        this.writer.clear(this.cacheName);
    }

    public void evict(Object key) {
        Assert.isTrue((boolean)(key instanceof String), (String)"'key' must be an instance of 'java.lang.String'.");
        this.writer.remove(this.cacheName, (String)key);
    }

    public Cache.ValueWrapper get(Object key) {
        try {
            Object value = this.getFromCache(key);
            return new SimpleValueWrapper(value);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public <T> T get(Object key, Class<T> type) {
        try {
            Object value = this.getFromCache(key);
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Unable to cast the object.", e);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Assert.isTrue((boolean)(key instanceof String), (String)"'key' must be an instance of 'java.lang.String'.");
        Assert.notNull(valueLoader, (String)"'valueLoader' must not be null.");
        Cache.ValueWrapper cached = this.get(key);
        if (cached != null) {
            return (T)cached.get();
        }
        try {
            T value = valueLoader.call();
            this.put(key, value);
            return value;
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
    }

    public final boolean isFlushOnBoot() {
        return this.cacheConfig.isFlushOnBoot();
    }

    public String getName() {
        return this.cacheName;
    }

    public Object getNativeCache() {
        return this.writer.getNativeCacheWriter();
    }

    public final Duration getTtl() {
        return this.cacheConfig.getTtl();
    }

    public final List<RootAttributeConfig> getRootAttributes() {
        return this.cacheConfig.getRootAttributes();
    }

    public final DynamoCacheWriter getWriter() {
        return this.writer;
    }

    public final DynamoSerializer getSerializer() {
        return this.cacheConfig.getSerializer();
    }

    public void put(Object key, Object value) {
        Assert.isTrue((boolean)(key instanceof String), (String)"'key' must be an instance of 'java.lang.String'.");
        this.writer.put(this.cacheName, (String)key, this.serialize(value), this.cacheConfig.getTtl(), this.readRootAttributes(this.cacheConfig.getRootAttributes(), value));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Assert.isTrue((boolean)(key instanceof String), (String)"'key' must be an instance of 'java.lang.String'.");
        byte[] result = this.writer.putIfAbsent(this.cacheName, (String)key, this.serialize(value), this.cacheConfig.getTtl(), this.readRootAttributes(this.cacheConfig.getRootAttributes(), value));
        if (result != null) {
            LOGGER.debug(String.format("Key: %s already exists in the cache. Element will not be replaced.", key));
            return new SimpleValueWrapper(this.deserialize(result));
        }
        return null;
    }

    private Object getFromCache(Object key) {
        Assert.isTrue((boolean)(key instanceof String), (String)"'key' must be an instance of 'java.lang.String'.");
        byte[] element = this.writer.get(this.cacheName, (String)key);
        return this.deserialize(element);
    }

    private void initialize() {
        if (this.cacheConfig.isFlushOnBoot()) {
            this.clear();
        }
        this.writer.createIfNotExists(this.cacheName, this.cacheConfig.getTtl(), this.cacheConfig.getReadCapacityUnits(), this.cacheConfig.getWriteCapacityUnits());
    }

    private Object deserialize(byte[] value) {
        return this.cacheConfig.getSerializer().deserialize(value);
    }

    private byte[] serialize(Object value) {
        return this.cacheConfig.getSerializer().serialize(value);
    }

    private List<RootAttribute> readRootAttributes(List<RootAttributeConfig> rootAttributeConfigs, Object value) {
        return rootAttributeConfigs.stream().map(rootAttributeConfig -> this.rootAttributeReader.readRootAttribute((RootAttributeConfig)rootAttributeConfig, value)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

