/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.dasburo.spring.cache.dynamo.DynamoCache;
import com.dasburo.spring.cache.dynamo.DynamoCacheConfiguration;
import com.dasburo.spring.cache.dynamo.DynamoCacheWriter;
import com.dasburo.spring.cache.dynamo.rootattribute.RootAttributeConfig;
import com.dasburo.spring.cache.dynamo.serializer.DynamoSerializer;
import java.time.Duration;
import java.util.List;
import org.springframework.util.Assert;

public class DynamoCacheBuilder {
    private String cacheName;
    private DynamoCacheWriter writer;
    private DynamoCacheConfiguration cacheConfig;

    protected DynamoCacheBuilder(String cacheName, AmazonDynamoDB dynamoTemplate) {
        Assert.notNull((Object)dynamoTemplate, (String)"'dynamoTemplate' must not be null.");
        Assert.hasText((String)cacheName, (String)"'cacheName' must not be null and must contain at least one non-whitespace character.");
        this.cacheName = cacheName;
        this.writer = DynamoCacheWriter.nonLockingDynamoCacheWriter(dynamoTemplate);
        this.cacheConfig = DynamoCacheConfiguration.defaultCacheConfig();
    }

    public static DynamoCacheBuilder newInstance(String cacheName, AmazonDynamoDB dynamoTemplate) {
        return new DynamoCacheBuilder(cacheName, dynamoTemplate);
    }

    public DynamoCache build() {
        return new DynamoCache(this.cacheName, this.writer, this.cacheConfig);
    }

    public DynamoCacheBuilder withFlushOnBoot(boolean flushOnBoot) {
        this.cacheConfig.setFlushOnBoot(flushOnBoot);
        return this;
    }

    public DynamoCacheBuilder withTTL(Duration ttl) {
        this.cacheConfig.setTtl(ttl);
        return this;
    }

    public DynamoCacheBuilder withReadCapacityUnit(Long readCapacityUnit) {
        this.cacheConfig.setReadCapacityUnits(readCapacityUnit);
        return this;
    }

    public DynamoCacheBuilder withWriteCapacityUnit(Long writeCapacityUnit) {
        this.cacheConfig.setWriteCapacityUnits(writeCapacityUnit);
        return this;
    }

    public DynamoCacheBuilder withSerializer(DynamoSerializer serializer) {
        this.cacheConfig.setSerializer(serializer);
        return this;
    }

    public DynamoCacheBuilder withRootAttributes(List<RootAttributeConfig> rootAttributeConfigs) {
        this.cacheConfig.setRootAttributes(rootAttributeConfigs);
        return this;
    }

    public DynamoCacheBuilder withWriter(DynamoCacheWriter writer) {
        this.writer = writer;
        return this;
    }
}

