/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo;

import com.dasburo.spring.cache.dynamo.rootattribute.RootAttributeConfig;
import com.dasburo.spring.cache.dynamo.serializer.DynamoSerializer;
import com.dasburo.spring.cache.dynamo.serializer.StringSerializer;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class DynamoCacheConfiguration {
    private Duration ttl;
    private boolean flushOnBoot;
    private Long readCapacityUnits;
    private Long writeCapacityUnits;
    private DynamoSerializer serializer;
    private List<RootAttributeConfig> rootAttributes;

    private DynamoCacheConfiguration(Duration ttl, boolean flushOnBoot, Long readCapacityUnits, Long writeCapacityUnits, DynamoSerializer serializer, List<RootAttributeConfig> rootAttributes) {
        this.ttl = ttl;
        this.flushOnBoot = flushOnBoot;
        this.readCapacityUnits = readCapacityUnits;
        this.writeCapacityUnits = writeCapacityUnits;
        this.serializer = serializer;
        this.rootAttributes = rootAttributes;
    }

    public static DynamoCacheConfiguration defaultCacheConfig() {
        return new DynamoCacheConfiguration(Duration.ZERO, false, 1L, 1L, new StringSerializer(), Collections.emptyList());
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public void setTtl(Duration ttl) {
        this.ttl = ttl;
    }

    public boolean isFlushOnBoot() {
        return this.flushOnBoot;
    }

    public void setFlushOnBoot(boolean flushOnBoot) {
        this.flushOnBoot = flushOnBoot;
    }

    public Long getReadCapacityUnits() {
        return this.readCapacityUnits;
    }

    public void setReadCapacityUnits(Long readCapacityUnits) {
        this.readCapacityUnits = readCapacityUnits;
    }

    public Long getWriteCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public void setWriteCapacityUnits(Long writeCapacityUnits) {
        this.writeCapacityUnits = writeCapacityUnits;
    }

    public DynamoSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(DynamoSerializer serializer) {
        this.serializer = serializer;
    }

    public List<RootAttributeConfig> getRootAttributes() {
        return this.rootAttributes;
    }

    public void setRootAttributes(List<RootAttributeConfig> rootAttributes) {
        this.rootAttributes = rootAttributes;
    }
}

